#####################################################################################
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 03 $
#
# Modified to Implement 'smb_nt.inc'
#  - By Sharath S <sharaths@secpod.com> On 2009-09-21
#
######################################################################################

if(description)
{
  script_id(90020);
  script_version ("$Revision: 03 $");
  script_tag(name:"cvss_base", value:"8.8");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-0087");
  script_bugtraq_id(28553);
  script_name("Windows vulnerability in DNS Client Could Allow Spoofing (945553)");
  desc = "
  The remote host is probably affected by the vulnerability described in
  CVE-2008-0087

  Impact:
  The DNS client in Microsoft Windows 2000 SP4, XP SP2, Server 2003 SP1 and SP2,
  and Vista uses predictable DNS transaction IDs, which allows remote attackers
  to spoof DNS responses.

  References:
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0087
  http://www.microsoft.com/technet/security/bulletin/ms08-020.mspx

  Solution:
  All Users should upgrade to the latest version.

  Risk factor : High";

  script_description(desc);
  script_summary("Windows vulnerability in DNS Client Could Allow Spoofing (945553)");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is under GPLv2");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:3, win2k:5, win2003:3) <= 0){
  exit(0);
}

# MS08-020 Hotfix check
if(hotfix_missing(name:"945553") == 0){
  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!dllPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\Dnsapi.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Dnsapi.dll version < 5.0.2195.7151
  if(version_is_less(version:dllVer, test_version:"5.0.2195.7151")){
    security_hole(0);
  }
}

# Windows XP
else if(hotfix_check_sp(xp:3) > 0)
{
  # Grep for Dnsapi.dll < 5.1.2600.3316
  if(version_is_less(version:dllVer, test_version:"5.1.2600.3316")){
    security_hole(0);
  }
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Dnsapi.dll version < 5.2.3790.4238
    if(version_is_less(version:dllVer, test_version:"5.2.3790.4238")){
      security_hole(0);
    }
  }
  if("Service Pack 1" >< SP)
  {
    # Grep for Dnsapi.dll version < 5.2.3790.3092
    if(version_is_less(version:dllVer, test_version:"5.2.3790.3092")){
      security_hole(0);
    }
  }
  else
    security_hole(0);
}
