/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __POWERD_H__
#define __POWERD_H__

#ifdef __cplusplus
extern "C" {
#endif

enum SysPowerStates {
    //Note that callers will be notified of suspend state changes
    //but may not request this state.
    POWERD_SYS_STATE_SUSPEND = 0,

    //The Active state will prevent system suspend
    POWERD_SYS_STATE_ACTIVE,
    //Substate of Active with disabled proximity based blanking
    POWERD_SYS_STATE_ACTIVE_BLANK_ON_PROXIMITY,

    POWERD_NUM_POWER_STATES
};

/*
 * Flags that can be applied to power states
 * TODO Create dedicated power states instead?
 */
enum SysPowerStateFlags {
    POWERD_POWER_STATE_FLAG_MASK = 0xFFFF0000,
    // disables display blanking on proximity events
    POWERD_DISABLE_PROXIMITY_SENSOR_BLANKING = 0x10000,
};

/*
 * Clients should treat this as an opaque type. Though this isn't really
 * possible until the client library is written.
 */
typedef char powerd_cookie_t[37];

#ifdef __cplusplus
}
#endif

#endif
