# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PropertyEntityBaseParameters(Model):
    """Property Entity Base Parameters set.

    :param tags: Optional tags that when provided can be used to filter the
     property list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be
     encrypted or not. Default value is false.
    :type secret: bool
    """

    _validation = {
        'tags': {'max_items': 32},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
    }

    def __init__(self, *, tags=None, secret: bool=None, **kwargs) -> None:
        super(PropertyEntityBaseParameters, self).__init__(**kwargs)
        self.tags = tags
        self.secret = secret
