# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .error_info import ErrorInfo


class AzureResourceErrorInfo(ErrorInfo):
    """The azure resource error info.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code.
    :type code: str
    :param message: Required. The error message.
    :type message: str
    :param details: The error details.
    :type details: list[~azure.mgmt.logic.models.AzureResourceErrorInfo]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AzureResourceErrorInfo]'},
    }

    def __init__(self, **kwargs):
        super(AzureResourceErrorInfo, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)
