# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CheckNameAvailabilityResult(Model):
    """Describes the result of the request to check management group name
    availability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: Required. True indicates name is valid and
     available. False indicates the name is invalid, unavailable, or both.
    :vartype name_available: bool
    :ivar reason: Required if nameAvailable == false. Invalid indicates the
     name provided does not match the resource provider's naming requirements
     (incorrect length, unsupported characters, etc.) AlreadyExists indicates
     that the name is already in use and is therefore unavailable. Possible
     values include: 'Invalid', 'AlreadyExists'
    :vartype reason: str or ~azure.mgmt.managementgroups.models.Reason
    :ivar message: Required if nameAvailable == false. Localized. If reason ==
     invalid, provide the user with the reason why the given name is invalid,
     and provide the resource naming requirements so that the user can select a
     valid name. If reason == AlreadyExists, explain that is already in use,
     and direct them to select a different name.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'Reason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None
