# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AddDataLakeStoreWithAccountParameters(Model):
    """The parameters used to add a new Data Lake Store account while creating a
    new Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the Data Lake Store account to
     add.
    :type name: str
    :param suffix: The optional suffix for the Data Lake Store account.
    :type suffix: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'suffix': {'key': 'properties.suffix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AddDataLakeStoreWithAccountParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.suffix = kwargs.get('suffix', None)
