# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from ..._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_request(
    resource_group_name: str,
    account_name: str,
    subscription_id: str,
    *,
    maxpagesize: Optional[str] = None,
    filter: Optional[str] = None,
    include: Optional[Union[str, _models.ListContainersInclude]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if maxpagesize is not None:
        _params["$maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if include is not None:
        _params["$include"] = _SERIALIZER.query("include", include, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, **kwargs)


def build_set_legal_hold_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_clear_legal_hold_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_or_update_immutability_policy_request(
    resource_group_name: str,
    account_name: str,
    container_name: str,
    subscription_id: str,
    *,
    if_match: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "immutabilityPolicyName": _SERIALIZER.url("immutability_policy_name", immutability_policy_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_immutability_policy_request(
    resource_group_name: str,
    account_name: str,
    container_name: str,
    subscription_id: str,
    *,
    if_match: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "immutabilityPolicyName": _SERIALIZER.url("immutability_policy_name", immutability_policy_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_immutability_policy_request(
    resource_group_name: str,
    account_name: str,
    container_name: str,
    subscription_id: str,
    *,
    if_match: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "immutabilityPolicyName": _SERIALIZER.url("immutability_policy_name", immutability_policy_name, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_lock_immutability_policy_request(
    resource_group_name: str,
    account_name: str,
    container_name: str,
    subscription_id: str,
    *,
    if_match: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_extend_immutability_policy_request(
    resource_group_name: str,
    account_name: str,
    container_name: str,
    subscription_id: str,
    *,
    if_match: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_lease_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/lease",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_object_level_worm_request(
    resource_group_name: str, account_name: str, container_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/migrate",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1, pattern=r"^[-\w\._\(\)]+$"
        ),
        "accountName": _SERIALIZER.url("account_name", account_name, "str", max_length=24, min_length=3),
        "containerName": _SERIALIZER.url("container_name", container_name, "str", max_length=63, min_length=3),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class BlobContainersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.storage.v2021_06_01.StorageManagementClient`'s
        :attr:`blob_containers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        account_name: str,
        maxpagesize: Optional[str] = None,
        filter: Optional[str] = None,
        include: Optional[Union[str, _models.ListContainersInclude]] = None,
        **kwargs: Any
    ) -> Iterable["_models.ListContainerItem"]:
        """Lists all containers and does not support a prefix like data plane. Also SRP today does not
        return continuation token.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param maxpagesize: Optional. Specified maximum number of containers that can be included in
         the list. Default value is None.
        :type maxpagesize: str
        :param filter: Optional. When specified, only container names starting with the filter will be
         listed. Default value is None.
        :type filter: str
        :param include: Optional, used to include the properties for soft deleted blob containers.
         "deleted" Default value is None.
        :type include: str or ~azure.mgmt.storage.v2021_06_01.models.ListContainersInclude
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ListContainerItem or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.storage.v2021_06_01.models.ListContainerItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[_models.ListContainerItems] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    maxpagesize=maxpagesize,
                    filter=filter,
                    include=include,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("ListContainerItems", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers"
    }

    @overload
    def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: _models.BlobContainer,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties of the blob container to create. Required.
        :type blob_container: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties of the blob container to create. Required.
        :type blob_container: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: Union[_models.BlobContainer, IO],
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Creates a new container under the specified account as described by request body. The container
        resource includes metadata and properties for that container. It does not include a list of the
        blobs contained by the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties of the blob container to create. Is either a BlobContainer
         type or a IO type. Required.
        :type blob_container: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BlobContainer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(blob_container, (IO, bytes)):
            _content = blob_container
        else:
            _json = self._serialize.body(blob_container, "BlobContainer")

        request = build_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("BlobContainer", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("BlobContainer", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}"
    }

    @overload
    def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: _models.BlobContainer,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties to update for the blob container. Required.
        :type blob_container: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties to update for the blob container. Required.
        :type blob_container: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        blob_container: Union[_models.BlobContainer, IO],
        **kwargs: Any
    ) -> _models.BlobContainer:
        """Updates container properties as specified in request body. Properties not mentioned in the
        request will be unchanged. Update fails if the specified container doesn't already exist.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param blob_container: Properties to update for the blob container. Is either a BlobContainer
         type or a IO type. Required.
        :type blob_container: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BlobContainer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(blob_container, (IO, bytes)):
            _content = blob_container
        else:
            _json = self._serialize.body(blob_container, "BlobContainer")

        request = build_update_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BlobContainer", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}"
    }

    @distributed_trace
    def get(
        self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any
    ) -> _models.BlobContainer:
        """Gets properties of a specified container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobContainer or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.BlobContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[_models.BlobContainer] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BlobContainer", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}"
    }

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any
    ) -> None:
        """Deletes specified container under its account.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}"
    }

    @overload
    def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: _models.LegalHold,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container. Required.
        :type legal_hold: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container. Required.
        :type legal_hold: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def set_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: Union[_models.LegalHold, IO],
        **kwargs: Any
    ) -> _models.LegalHold:
        """Sets legal hold tags. Setting the same tag results in an idempotent operation. SetLegalHold
        follows an append pattern and does not clear out the existing tags that are not specified in
        the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be set to a blob container. Is either a
         LegalHold type or a IO type. Required.
        :type legal_hold: ~azure.mgmt.storage.v2021_06_01.models.LegalHold or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LegalHold] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(legal_hold, (IO, bytes)):
            _content = legal_hold
        else:
            _json = self._serialize.body(legal_hold, "LegalHold")

        request = build_set_legal_hold_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set_legal_hold.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LegalHold", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set_legal_hold.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold"
    }

    @overload
    def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: _models.LegalHold,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container. Required.
        :type legal_hold: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LegalHold:
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container. Required.
        :type legal_hold: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def clear_legal_hold(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        legal_hold: Union[_models.LegalHold, IO],
        **kwargs: Any
    ) -> _models.LegalHold:
        """Clears legal hold tags. Clearing the same or non-existent tag results in an idempotent
        operation. ClearLegalHold clears out only the specified tags in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param legal_hold: The LegalHold property that will be clear from a blob container. Is either a
         LegalHold type or a IO type. Required.
        :type legal_hold: ~azure.mgmt.storage.v2021_06_01.models.LegalHold or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LegalHold or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LegalHold
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LegalHold] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(legal_hold, (IO, bytes)):
            _content = legal_hold
        else:
            _json = self._serialize.body(legal_hold, "LegalHold")

        request = build_clear_legal_hold_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.clear_legal_hold.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LegalHold", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    clear_legal_hold.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold"
    }

    @overload
    def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional[_models.ImmutabilityPolicy] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Default value is None.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container. Default value is None.
        :type parameters: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword immutability_policy_name: The name of the blob container immutabilityPolicy within the
         specified storage account. ImmutabilityPolicy Name must be 'default'. Default value is
         "default". Note that overriding this default value may result in unsupported behavior.
        :paramtype immutability_policy_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Default value is None.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container. Default value is None.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword immutability_policy_name: The name of the blob container immutabilityPolicy within the
         specified storage account. ImmutabilityPolicy Name must be 'default'. Default value is
         "default". Note that overriding this default value may result in unsupported behavior.
        :paramtype immutability_policy_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_or_update_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        parameters: Optional[Union[_models.ImmutabilityPolicy, IO]] = None,
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Creates or updates an unlocked immutability policy. ETag in If-Match is honored if given but
        not required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Default value is None.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be created or updated to a blob
         container. Is either a ImmutabilityPolicy type or a IO type. Default value is None.
        :type parameters: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy or IO
        :keyword immutability_policy_name: The name of the blob container immutabilityPolicy within the
         specified storage account. ImmutabilityPolicy Name must be 'default'. Default value is
         "default". Note that overriding this default value may result in unsupported behavior.
        :paramtype immutability_policy_name: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "ImmutabilityPolicy")
            else:
                _json = None

        request = build_create_or_update_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            immutability_policy_name=immutability_policy_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_immutability_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    create_or_update_immutability_policy.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}"
    }

    @distributed_trace
    def get_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Gets the existing immutability policy along with the corresponding ETag in response headers and
        body.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Default value is None.
        :type if_match: str
        :keyword immutability_policy_name: The name of the blob container immutabilityPolicy within the
         specified storage account. ImmutabilityPolicy Name must be 'default'. Default value is
         "default". Note that overriding this default value may result in unsupported behavior.
        :paramtype immutability_policy_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        request = build_get_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            immutability_policy_name=immutability_policy_name,
            api_version=api_version,
            template_url=self.get_immutability_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_immutability_policy.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}"
    }

    @distributed_trace
    def delete_immutability_policy(
        self, resource_group_name: str, account_name: str, container_name: str, if_match: str, **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Aborts an unlocked immutability policy. The response of delete has
        immutabilityPeriodSinceCreationInDays set to 0. ETag in If-Match is required for this
        operation. Deleting a locked immutability policy is not allowed, the only way is to delete the
        container after deleting all expired blobs inside the policy locked container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Required.
        :type if_match: str
        :keyword immutability_policy_name: The name of the blob container immutabilityPolicy within the
         specified storage account. ImmutabilityPolicy Name must be 'default'. Default value is
         "default". Note that overriding this default value may result in unsupported behavior.
        :paramtype immutability_policy_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        immutability_policy_name: Literal["default"] = kwargs.pop("immutability_policy_name", "default")
        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        request = build_delete_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            immutability_policy_name=immutability_policy_name,
            api_version=api_version,
            template_url=self.delete_immutability_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    delete_immutability_policy.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}"
    }

    @distributed_trace
    def lock_immutability_policy(
        self, resource_group_name: str, account_name: str, container_name: str, if_match: str, **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Sets the ImmutabilityPolicy to Locked state. The only action allowed on a Locked policy is
        ExtendImmutabilityPolicy action. ETag in If-Match is required for this operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Required.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        request = build_lock_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            template_url=self.lock_immutability_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    lock_immutability_policy.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock"
    }

    @overload
    def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional[_models.ImmutabilityPolicy] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Required.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container. Default value is None.
        :type parameters: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Required.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container. Default value is None.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def extend_immutability_policy(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        if_match: str,
        parameters: Optional[Union[_models.ImmutabilityPolicy, IO]] = None,
        **kwargs: Any
    ) -> _models.ImmutabilityPolicy:
        """Extends the immutabilityPeriodSinceCreationInDays of a locked immutabilityPolicy. The only
        action allowed on a Locked policy will be this action. ETag in If-Match is required for this
        operation.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param if_match: The entity state (ETag) version of the immutability policy to update. A value
         of "*" can be used to apply the operation only if the immutability policy already exists. If
         omitted, this operation will always be applied. Required.
        :type if_match: str
        :param parameters: The ImmutabilityPolicy Properties that will be extended for a blob
         container. Is either a ImmutabilityPolicy type or a IO type. Default value is None.
        :type parameters: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ImmutabilityPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.ImmutabilityPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ImmutabilityPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "ImmutabilityPolicy")
            else:
                _json = None

        request = build_extend_immutability_policy_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.extend_immutability_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("ImmutabilityPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    extend_immutability_policy.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend"
    }

    @overload
    def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional[_models.LeaseContainerRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LeaseContainerResponse:
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param parameters: Lease Container request body. Default value is None.
        :type parameters: ~azure.mgmt.storage.v2021_06_01.models.LeaseContainerRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LeaseContainerResponse or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LeaseContainerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.LeaseContainerResponse:
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param parameters: Lease Container request body. Default value is None.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LeaseContainerResponse or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LeaseContainerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def lease(
        self,
        resource_group_name: str,
        account_name: str,
        container_name: str,
        parameters: Optional[Union[_models.LeaseContainerRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.LeaseContainerResponse:
        """The Lease Container operation establishes and manages a lock on a container for delete
        operations. The lock duration can be 15 to 60 seconds, or can be infinite.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :param parameters: Lease Container request body. Is either a LeaseContainerRequest type or a IO
         type. Default value is None.
        :type parameters: ~azure.mgmt.storage.v2021_06_01.models.LeaseContainerRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LeaseContainerResponse or the result of cls(response)
        :rtype: ~azure.mgmt.storage.v2021_06_01.models.LeaseContainerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LeaseContainerResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _json = self._serialize.body(parameters, "LeaseContainerRequest")
            else:
                _json = None

        request = build_lease_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.lease.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LeaseContainerResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    lease.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/lease"
    }

    def _object_level_worm_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_object_level_worm_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._object_level_worm_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _object_level_worm_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/migrate"
    }

    @distributed_trace
    def begin_object_level_worm(
        self, resource_group_name: str, account_name: str, container_name: str, **kwargs: Any
    ) -> LROPoller[None]:
        """This operation migrates a blob container from container level WORM to object level immutability
        enabled container. Prerequisites require a container level immutability policy either in locked
        or unlocked state, Account level versioning must be enabled and there should be no Legal hold
        on the container.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param account_name: The name of the storage account within the specified resource group.
         Storage account names must be between 3 and 24 characters in length and use numbers and
         lower-case letters only. Required.
        :type account_name: str
        :param container_name: The name of the blob container within the specified storage account.
         Blob container names must be between 3 and 63 characters in length and use numbers, lower-case
         letters and dash (-) only. Every dash (-) character must be immediately preceded and followed
         by a letter or number. Required.
        :type container_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01"] = kwargs.pop("api_version", _params.pop("api-version", "2021-06-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self._object_level_worm_initial(  # type: ignore
                resource_group_name=resource_group_name,
                account_name=account_name,
                container_name=container_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_object_level_worm.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/migrate"
    }
