# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databoxedge.aio import DataBoxEdgeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxEdgeManagementStorageAccountCredentialsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxEdgeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_account_credentials_list_by_data_box_edge_device(self, resource_group):
        response = self.client.storage_account_credentials.list_by_data_box_edge_device(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_account_credentials_get(self, resource_group):
        response = await self.client.storage_account_credentials.get(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_account_credentials_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.storage_account_credentials.begin_create_or_update(
                device_name="str",
                name="str",
                resource_group_name=resource_group.name,
                storage_account_credential={
                    "accountType": "str",
                    "alias": "str",
                    "sslStatus": "str",
                    "accountKey": {"encryptionAlgorithm": "str", "value": "str", "encryptionCertThumbprint": "str"},
                    "blobDomainName": "str",
                    "connectionString": "str",
                    "id": "str",
                    "name": "str",
                    "storageAccountId": "str",
                    "type": "str",
                    "userName": "str",
                },
                api_version="2019-08-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_storage_account_credentials_begin_delete(self, resource_group):
        response = await (
            await self.client.storage_account_credentials.begin_delete(
                device_name="str",
                name="str",
                resource_group_name=resource_group.name,
                api_version="2019-08-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
