# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.frontline_api.v1.user import UserList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of FrontlineApi

        :returns: V1 version of FrontlineApi
        :rtype: twilio.rest.frontline_api.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._users = None

    @property
    def users(self):
        """
        :rtype: twilio.rest.frontline_api.v1.user.UserList
        """
        if self._users is None:
            self._users = UserList(self)
        return self._users

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FrontlineApi.V1>'
