/*
 *
 * image writer class for DeadDiscReader
 * Copyright (C) 2007, Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 */


#define __USE_LARGEFILE64
#define _FILE_OFFSET_BITS 64

#include <stdio.h>
//#include <stdlib.h>

//#include <qpx_mmc.h>
//#include <sectmap.h>

#include <sectmap.h>
#include "imgwriter.h"

imgwriter::imgwriter(char* fn, smap* map) {
	mutex = new Mutex();
    fname=fn;

    if (!(iso = fopen(fname,"r+"))){
	printf("can't open image file, creating new one!\n");
	if (!(iso = fopen(fname,"w+"))){
	    printf("can't create image file!\n");
	}
    } else {
	printf("image opened: '%s'\n", fname);
	map->load();
    }
}

imgwriter::~imgwriter() {
	delete mutex;
}

int imgwriter::write(int lba, int scnt, int ssz, void* buff) {
	int res=0;
    mutex->lock();
    iso = fopen(fname, "r+");
    if (iso) {
#ifdef fseeko
		fseeko(iso, ssz*(__off_t)lba, SEEK_SET);
#else
		fseek(iso, ssz*(long int)lba, SEEK_SET);
#endif
		fwrite(buff, ssz*scnt, 1, iso);
		fclose(iso);
    }
    mutex->unlock();
	return res;
}

//void	imgwriter::set_file(char* fn) { fname=fn; }

//int	imgwriter::open(){}

//int	imgwriter::close(){}
