// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "framepseudo.h"

FramePseudo::FramePseudo(Tcl_Interp* i, Tk_Canvas c, Tk_Item* item)
  : FrameBase(i, c, item)
{
}

FramePseudo::~FramePseudo()
{
}

void FramePseudo::rotateMotion()
{
  // Rotate from src to dest
  Vector c = Vector(options->width,options->height)/2;
  Matrix m = (Translate(-c) * 
	      Rotate(rotation-rotateRotation) * Translate(c)).invert();
  double* mm = m.mm();
  unsigned long bgc = getColor(bgColorName);

  int& width = options->width;
  int& height = options->height;
  char* src = XImageData(rotateSrcXM);

  for (int j=0; j<height; j++) {
    // the line may be padded at the end
    char* dest = XImageData(rotateDestXM) + j*rotateDestXM->bytes_per_line;

    for (int i=0; i<width; i++, dest++) {
      double x = i*mm[0] + j*mm[3] + mm[6];
      double y = i*mm[1] + j*mm[4] + mm[7];

      if (x >= 0 && x < width && y >= 0 && y < height)
	*dest = src[((int)y)*rotateSrcXM->bytes_per_line + (int)x];
      else
	*dest = bgc;
    }
  }

  // XImage to Pixmap
  XPutImage(display, rotatePM, gc, rotateDestXM,
	    0, 0, 0, 0, options->width, options->height);

  // Display Pixmap
  Vector dd = Vector() * widgetToWindow;
  XCopyArea(display, rotatePM, Tk_WindowId(tkwin), rotateGCXOR, 0, 0, 
	    options->width, options->height, dd[0], dd[1]);
}

