/*
  syntax.hh, copyright (c) 2006 by Vincent Fourmond: 
  The class for describing syntax errors
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

namespace SCalc {

  /**
     \brief A syntax error
     This class represents a syntax error. You can get several informations
     about this error, such as the original_string(), the error_message(),
     the exact location of the error in the string
     (start_pos() and end_pos()).
   */
  class SyntaxError : public  ParserResult {
  protected:
    std::string original;
    std::string message;
    int start;
    int end;
  public:

    /// Yes, this is a syntax error
    virtual int is_syntax_error() { return 1;};

    SyntaxError(Session * s, const char * str, 
		const char *error, int st, int en);

    /// The original string on which the error occured
    std::string original_string() { return original;};
    /// The error message
    std::string error_message() { return message;};
    /// The starting position
    int start_pos() { return start;};
    /// The end position
    int end_pos() { return end;};
    
    /**
       \brief Pretty prints the error message
       Returns a std::string containing a nice display of
       the error message, with a series of ^^^^ showing
       where the error occurred. This function assumes that
       all characters have the same display size. 
    */
    virtual std::string pretty_print();
  };
};
