{
  description = "sisu parser & document generator";
  inputs.nixpkgs.url = "github:NixOS/nixpkgs/nixpkgs-unstable"; # "github:nixos/nixpkgs"; "github:NixOS/nixpkgs/nixpkgs-unstable"; "nixpkgs/nixos-unstable"; "nixpkgs/nixos-21.11";
  inputs.flake-utils.url = "github:numtide/flake-utils";
  outputs = {
    self,
    nixpkgs,
    flake-utils,
  } @ inputs: let
    pname = "sisu";
    version = "0.7.3";
    shell = ./shell.nix; # ./default.nix;
    devEnv = ./shell.nix; # ./.envrc; # ./shell.nix; # ./default.nix;
    supportedSystems = ["x86_64-linux"]; # [ "x86_64-linux" "x86_64-darwin" "aarch64-linux" "aarch64-darwin" ];
    forAllSystems = nixpkgs.lib.genAttrs supportedSystems;
    nixpkgsFor = forAllSystems (system: import nixpkgs {inherit system;}); # nixpkgs instantiated for supported system types
    checkPhase = ''
      runHook preCheck
      runHook postCheck
    '';
    preInstall = "";
    installPhase = ''
      runHook preInstall
      mkdir -p $out/lib
      mkdir -p $out/setup
      mkdir -p $out/data
      mkdir -p $out/bin
      cp -R ./lib/* $out/lib/.
      cp -R ./data/* $out/data/.
      cp -R ./setup/* $out/setup/.
      ln -s $out/setup/sisu_version.rb $out/version
      install -m755 ./bin/sisu $out/bin/sisu
      runHook postInstall
    '';
    postInstall = "";
  in {
    packages = forAllSystems (system: let
      pkgs = nixpkgsFor.${system};
    in
      with pkgs; {
        default = stdenv.mkDerivation {
          inherit pname;
          inherit version;
          meta.mainProgram = "sisu";
          executable = true;
          src = self;
          inherit shell;
          inherit devEnv;
          buildPhase = "";
          inherit checkPhase;
          inherit installPhase;
          inherit postInstall;
        };
        #vendorSha256 = "sha256-0Q00000000000000000000000000000000000000000=";
      });
    apps = forAllSystems (system: {
      default = {
        type = "app";
        program = "${self.packages.${system}.default}/bin/sisu";
      };
    });
    devShells = forAllSystems (system: let
      pkgs = nixpkgsFor.${system};
      shellHook = ''
        #${pkgs.nix}/bin/nix build ".#" --print-build-logs;
        nix build ".#" --print-build-logs;
        echo ""
        sisu -v
      '';
    in
      with pkgs; {
        default = mkShell {
          name = "sisu dev base shell";
          inherit shell;
          inherit devEnv;
          packages = [
            ruby_3_3
            rubyPackages_3_3.rake
            rubyPackages_3_3.sqlite3
            rubyPackages_3_3.thor
            sqlite
            jq
            git
          ];
          inherit shellHook;
        };
        dsh-epub = mkShell {
          name = "sisu dev shell for epub output";
          inherit shell;
          inherit devEnv;
          packages = [
            ruby_3_3
            rubyPackages_3_3.rake
            rubyPackages_3_3.sqlite3
            rubyPackages_3_3.thor
            sqlite
            graphicsmagick
            zip
            unzip
            xz
            libxml2
            html-tidy
            xmlstarlet
            epubcheck
            ebook_tools
            libxml2
            html-tidy
            xmlstarlet
            epubcheck
            ebook_tools
            epr
            sigil
            calibre #(suite includes: ebook-viewer)
            foliate
            jq
            #git
          ];
          inherit shellHook;
        };
        dsh-html = mkShell {
          name = "sisu dev shell for html output";
          inherit shell;
          inherit devEnv;
          packages = [
            ruby_3_3
            rubyPackages_3_3.rake
            rubyPackages_3_3.sqlite3
            rubyPackages_3_3.thor
            sqlite
            graphicsmagick
            zip
            unzip
            xz
            jq
            #git
          ];
          inherit shellHook;
        };
        dsh-latex-pdf = mkShell {
          name = "sisu dev shell for latex & pdf output";
          inherit shell;
          inherit devEnv;
          packages = [
            ruby_3_3
            rubyPackages_3_3.rake
            rubyPackages_3_3.sqlite3
            rubyPackages_3_3.thor
            sqlite
            graphicsmagick
            zip
            unzip
            xz
            source-sans-pro
            source-serif-pro
            source-code-pro
            texlive.combined.scheme-full
            noto-fonts
            noto-fonts-cjk-sans
            takao
            jq
            #git
          ];
          inherit shellHook;
        };
        dsh-sqlite = mkShell {
          name = "sisu dev shell for sqlite3 output";
          inherit shell;
          inherit devEnv;
          packages = [
            ruby_3_3
            rubyPackages_3_3.rake
            rubyPackages_3_3.sqlite3
            rubyPackages_3_3.thor
            sqlite
            graphicsmagick
            zip
            unzip
            xz
            jq
            #git
          ];
          inherit shellHook;
        };
        dsh-i18n = mkShell {
          name = "sisu dev shell internationalization, po4a";
          inherit shell;
          inherit devEnv;
          packages = [
            ruby_3_3
            rubyPackages_3_3.rake
            rubyPackages_3_3.sqlite3
            rubyPackages_3_3.thor
            sqlite
            graphicsmagick
            perl538Packages.Po4a
            jq
            #git
          ];
          inherit shellHook;
        };
        #default = import ./shell.nix {inherit pkgs;};
      });
  };
}
