/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef UKCCSESSIONSERVER_H
#define UKCCSESSIONSERVER_H

#include <QObject>
#include <QFile>
#include <QTextStream>
#include <QDir>
#include <QDebug>
#include <QVariantMap>
#include <QCoreApplication>
#include <QDBusContext>
#include <QScopedPointer>
#include <QDBusVariant>
#include <QFileSystemWatcher>
#include <QSettings>
#ifdef KY_SDK_SYSINFO
#include <kysdk/kysdk-system/libkysysinfo.h>
#endif
#include "screenStruct.h"

class ukccSessionServer : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.interface")
public:
    explicit ukccSessionServer();

private:
    QMap<QString, QVariant> getJsonInfo(const  QString &confFile);
    void monitoFileChanged();

private:
    QString mScreenMode;
    QVariantList mPreScreenCfg;
    QString mFilePath;

Q_SIGNALS:
    void configChanged();
    void screenChanged(QString status);
    void searchItemsAdd(QVariantMap addItems);
    void searchItemsDelete(QVariantMap deleteItems);

public Q_SLOTS:
    void exitService();
    void        ReloadSecurityConfig();
    QVariantMap getModuleHideStatus();
    QVariantMap getSearchItems();
    QString     GetSecurityConfigPath();
    QString getScreenMode();
    void setScreenMode(QString screenMode);
    void setPreScreenCfg(QVariantList preScreenCfg);
    QVariantList getPreScreenCfg();
};

#endif // UKCCSESSIONSERVER_H
