# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - self.VideoporamaInstance.ProjectXMLObjectinique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import sys
import os
import subprocess
import Image
import StringIO
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from xml.dom import minidom
from xml.dom.minidom import Document
from GlobalDefines import *

class VideoporamaOFD :
    def __init__(self,XMLFile,VideoporamaInstance) :
      self.VideoporamaInstance = VideoporamaInstance  # Access to main window
      fo=open(XMLFile,'r')
      self.OutputOFDXMLObject=minidom.parse(fo)       # Output format definition XML Object
      fo.close()

    def GetAllProperties(self,OFDDeviceType,OFDDeviceModel,OFDOutputCodec,imgformat,OFDOutputFormat):
        xmlroot        =self.OutputOFDXMLObject.getElementsByTagName(u"VideoporamaOutputFormatDefinition")[0]
        xmlDeviceType  =getElementsByAttributName(xmlroot,OFDDeviceType)
        xmlDeviceModel =getElementsByAttributName(xmlDeviceType,OFDDeviceModel)
        xmlOutputCodec =getElementsByAttributName(xmlDeviceModel,OFDOutputCodec)
        if imgformat==1: 
          xmlGeometry  =getElementsByAttributName(xmlOutputCodec,"Wide - 16:9")
        else: 
          xmlGeometry  =getElementsByAttributName(xmlOutputCodec,"Normal - 4:3")
        xmlFormat      =getElementsByAttributName(xmlGeometry,OFDOutputFormat)

        Name           =xmlFormat.getAttribute("Name")
        imgpsec        =int(xmlFormat.getAttribute(u'FPS'))
        widthpict      =int(xmlFormat.getAttribute(u'Width'))
        heightpict     =int(xmlFormat.getAttribute(u'Height'))
        ext            =xmlFormat.getAttribute(u'Ext')
        Commande       =QString(xmlFormat.getAttribute(u'Cmd'))
        TestAudio      =xmlFormat.getAttribute("TestAudio")
        TestVideo      =xmlFormat.getAttribute("TestVideo")
        TestFile       =xmlFormat.getAttribute("TestFile")

        return Name,imgpsec,widthpict,heightpict,ext,Commande,TestAudio,TestVideo,TestFile

    # Parse Output Format Definition for filling DeviceTypeCB
    def GetOFDDeviceTypeCBList(self,imgformat):
      List=QStringList()
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          if self.GetOFDDeviceModelCBList(OutputDeviceType.getAttribute("Name"),imgformat).count()>0:
            List.append(OutputDeviceType.getAttribute("Name"))
      return List

    # Parse Output Format Definition for filling DeviceModelCB
    def GetOFDDeviceModelCBList(self,OFDDeviceType,imgformat):
      List=QStringList()
      for OutputDeviceType in self.VideoporamaInstance.OutputOFDXMLObject.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==OFDDeviceType:
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                if self.GetOFDOutputCodecCBList(OFDDeviceType,OutputDeviceModel.getAttribute("Name"),imgformat).count()>0:
                  List.append(OutputDeviceModel.getAttribute("Name"))
      return List

    # Parse Output Format Definition for filling OutputCodecCB
    def GetOFDOutputCodecCBList(self,OFDDeviceType,OFDDeviceModel,imgformat):
      List=QStringList()
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==OFDDeviceType:
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                DeviceModel=OutputDeviceModel.getAttribute("Name")
                if DeviceModel==OFDDeviceModel:
                  for OutputCodec in OutputDeviceModel.childNodes :
                    if OutputCodec.nodeType==OutputCodec.ELEMENT_NODE:
                      if self.GetOFDOutputFormatList(OFDDeviceType,OFDDeviceModel,OutputCodec.getAttribute("Name"),imgformat).count()>0:
                        List.append(OutputCodec.getAttribute("Name"))
      return List

    # Parse Output Format Definition for filling OutputFormatCB
    def GetOFDOutputFormatList(self,OFDDeviceType,OFDDeviceModel,OFDOutputCodec,imgformat):
      List=QStringList()
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==OFDDeviceType:
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                DeviceModel=OutputDeviceModel.getAttribute("Name")
                if DeviceModel==OFDDeviceModel:
                  for OutputCodec in OutputDeviceModel.childNodes :
                    if OutputCodec.nodeType==OutputCodec.ELEMENT_NODE:
                      Codec=OutputCodec.getAttribute("Name")
                      if Codec==OFDOutputCodec:
                        for OutputGeometry in OutputCodec.childNodes :
                          if OutputGeometry.nodeType==OutputGeometry.ELEMENT_NODE:
                            if imgformat==1: 
                              Geometry  ="Wide - 16:9"
                            else: 
                              Geometry  ="Normal - 4:3"
                            if Geometry==OutputGeometry.getAttribute("Name"):
                              for OutputFormat in OutputGeometry.childNodes :
                                if OutputFormat.nodeType==OutputFormat.ELEMENT_NODE:
                                  IsTestVideo=False
                                  IsTestAudio=False
                                  IsTestFile =False
                                  for fmt in self.VideoporamaInstance.listformats : 
                                    if fmt==OutputFormat.getAttribute("TestVideo") : IsTestVideo=True
                                    TestAudio=OutputFormat.getAttribute("TestAudio")
                                    if TestAudio=="adts" and self.VideoporamaInstance.AACMode=="libfaac" : TestAudio=self.VideoporamaInstance.AACMode
                                    if fmt==TestAudio : IsTestAudio=True
                                    if fmt==OutputFormat.getAttribute("TestFile")  : IsTestFile=True
                                  if IsTestVideo and IsTestAudio :
                                    List.append(OutputFormat.getAttribute("Name"))
      return List
