/*
 *========================================================================
 * $Id: set_display_dctl_state.c 231 2004-07-07 01:08:54Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 * Set all the dctl state features according to a display type switch.
 *========================================================================
 */

#include "wulfstat.h"

void set_display_dctl_state(List *hostlist)
{

 Host *hostptr;
 ListElement *element;

 if((verbose == D_ALL) || (verbose == D_DISPLAY_VALUES)){
   fprintf(OUTFP,"D_DISPLAY_VALUES: Starting display_values().  Use -v %d to focus.\n",D_DISPLAY_VALUES);
 }

 switch(display.type) {
   case DISPLAY_LOAD:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       fprintf(OUTFP,"DISPLAY_LOAD: display_type = %d\n",DISPLAY_LOAD);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 1;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_NET:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       fprintf(OUTFP,"DISPLAY_NET: display_type = %d\n",DISPLAY_NET);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 1;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_TIMES:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       fprintf(OUTFP,"DISPLAY_TIMES: display_type = %d\n",DISPLAY_TIMES);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 1;
       hostptr->dctl.users = 1;
       hostptr->dctl.cpuinfo = 1;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 1;
       hostptr->dctl.version = 1;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_PIDS:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       fprintf(OUTFP,"DISPLAY_PIDS: display_type = %d\n",DISPLAY_PIDS);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 1;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_PIDS_CMDLINE:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       fprintf(OUTFP,"DISPLAY_PIDS: display_type = %d\n",DISPLAY_PIDS);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 1;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 1;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_MEMORY:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       fprintf(OUTFP,"DISPLAY_MEMORY: display_type = %d\n",DISPLAY_MEMORY);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 1;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_BASIC:
   default:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       fprintf(OUTFP,"DISPLAY_BASIC: display_type = %d\n",DISPLAY_BASIC);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 1;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 1;
       hostptr->dctl.stat = 1;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
 }

}

void dump_dctl_state(Host *hostptr)
{
 fprintf(OUTFP,"==================================\n");
 fprintf(OUTFP,"DCTL STATE DUMP for host %s:\n",hostptr->hostname);
 fprintf(OUTFP,"DISPLAY_BASIC: compress = %d\n",hostptr->dctl.compress);
 fprintf(OUTFP,"DISPLAY_BASIC: whitespace = %d\n",hostptr->dctl.whitespace);
 fprintf(OUTFP,"DISPLAY_BASIC: identity = %d\n",hostptr->dctl.identity);
 fprintf(OUTFP,"DISPLAY_BASIC: time = %d\n",hostptr->dctl.time);
 fprintf(OUTFP,"DISPLAY_BASIC: users = %d\n",hostptr->dctl.users);
 fprintf(OUTFP,"DISPLAY_BASIC: cpuinfo = %d\n",hostptr->dctl.cpuinfo);
 fprintf(OUTFP,"DISPLAY_BASIC: loadavg = %d\n",hostptr->dctl.loadavg);
 fprintf(OUTFP,"DISPLAY_BASIC: meminfo = %d\n",hostptr->dctl.meminfo);
 fprintf(OUTFP,"DISPLAY_BASIC: net = %d\n",hostptr->dctl.net);
 fprintf(OUTFP,"DISPLAY_BASIC: stat = %d\n",hostptr->dctl.stat);
 fprintf(OUTFP,"DISPLAY_BASIC: sysvipc = %d\n",hostptr->dctl.sysvipc);
 fprintf(OUTFP,"DISPLAY_BASIC: uptime = %d\n",hostptr->dctl.uptime);
 fprintf(OUTFP,"DISPLAY_BASIC: version = %d\n",hostptr->dctl.version);
 fprintf(OUTFP,"DISPLAY_BASIC: pids = %d\n",hostptr->dctl.pids);
 fprintf(OUTFP,"DISPLAY_BASIC: pidstats = %d\n",hostptr->dctl.pidstats);
 fprintf(OUTFP,"DISPLAY_BASIC: cmdline = %d\n",hostptr->dctl.cmdline);
 fprintf(OUTFP,"DISPLAY_BASIC: running = %d\n",hostptr->dctl.running);
 fprintf(OUTFP,"DISPLAY_BASIC: root = %d\n",hostptr->dctl.root);
 fprintf(OUTFP,"==================================\n");

}
