###--- >>> `whiteside' <<<----- House Insulation: Whiteside's Data

	## alias	 help(whiteside)

##___ Examples ___:

data(whiteside)
coplot(Gas ~ Temp | Insul, whiteside, panel = 
  function(x, y, ...) {
     points(x, y, ...)
     abline(lm(y ~ x))
  }, xlab = "Average external temperature (deg. C)",
  ylab = "Gas consumption  (1000 cubic feet)")

gasB <- lm(Gas ~ Temp, whiteside, subset=Insul=="Before")
gasA <- update(gasB, subset=Insul=="After")
summary(gasB)
summary(gasA)
gasBA <- lm(Gas ~ Insul/Temp - 1, whiteside)
summary(gasBA)

gasQ <- lm(Gas ~ Insul/(Temp + I(Temp^2)) - 1, whiteside)
summary(gasQ)$coef

gasPR <- lm(Gas ~ Insul + Temp, whiteside)  
anova(gasPR, gasBA)
options(contrasts = c("contr.treatment", "contr.poly"))
gasBA1 <- lm(Gas ~ Insul*Temp, whiteside)
summary(gasBA1)$coef

## Keywords: 'datasets'.


