###--- >>> `aggregate' <<<----- Compute Summary Statistics of Data Subsets

	## alias	 help(aggregate)
	## alias	 help(aggregate.default)
	## alias	 help(aggregate.data.frame)
	## alias	 help(aggregate.ts)

##___ Examples ___:

data(state)

## Compute the averages for the variables in `state.x77', grouped
## according to the region (Northeast, South, North Central, West) that
## each state belongs to.
aggregate(state.x77, list(Region = state.region), mean)

## Compute the averages according to region and the occurrence of more
## than 130 days of frost.
aggregate(state.x77,
          list(Region = state.region,
               Cold = state.x77[,"Frost"] > 130),
          mean)
## (Note that no state in `South' is THAT cold.)

data(presidents)
## Compute the average annual approval ratings for American presidents.
aggregate(presidents, nf = 1, FUN = mean)

## Keywords: 'category', 'array'.


