###--- >>> `coxre' <<<----- Cox Proportional Hazards Model with Random Effect

	## alias	 help(coxre)

##___ Examples ___:

# 11 individuals, each with 5 responses
y <- matrix(rweibull(55,2,5),ncol=5)
# Different intensity functions
coxre(response=y, censor=matrix(rep(1,55),ncol=5), nest=1:11,
	est=0.7, stratified=T)
# Proportional intensity functions
coxre(response=y, censor=matrix(rep(1,55),ncol=5),
	nest=1:11, cov=rpois(11,2), est=0.7, stratified=F)
# Identical intensity functions
coxre(response=as.vector(t(y)), censor=rep(1,55),
	nest=rep(1:11,rep(5,11)), est=0.7)



