###--- >>> `tps' <<<----- Thin plate spline regression

##___ Examples ___:


#1-d example

tps( rat.diet$t, rat.diet$trt) # lambda found by GCV
tps( rat.diet$t, rat.diet$trt, df=6) # lambda chosen so that spline has 6 
                                     # degrees of freedom

#2-d example
tps(ozone$x, ozone$y) -> fit # fits a surface to ozone measurements.
plot(fit) # plots fit and residuals.

#4-d example
tps(BD[,1:4],BD$lnya,scale.type="range") -> fit # fits a surface to
# DNA strand displacement amplification as a function of various 
# buffer components.
surface(fit)  
# plots fitted surface and contours



#2-d example using a reduced set of basis functions
r1 <- range(flame$x[,1])
r2 <-range( flame$x[,2])
g.list <- list(seq(r1[1], r1[2],6), seq(r2[1], r2[2], 6))
make.surface.grid(g.list) -> knots  # these knots are a 6X6 grid over
# the ranges of the two flame variables
tps(flame$x, flame$y, knots=knots, m=4) -> out 

# here is an example using a link matrix
# 
x<- seq( 0,1,.02)
f<- 8*(x**2)*(1-x)
M <- matrix( .02, ncol=50, nrow=50)
M[ col(M)< row( M)]<- 0 
set.seed( 123)
y<- M%*%f + error*.1 # So y is approximately the integral of f pus error
ex.out<-tps( x,y,link.matrix=M)
#Note: predict will give the spline NOT the predicted values for y!






## Keywords: 'splines,'.


