###--- >>> `nlr' <<<----- Nonlinear Regression

	## alias	 help(nlr)
	## alias	 help(coefficients.nlr)
	## alias	 help(deviance.nlr)
	## alias	 help(df.residual.nlr)
	## alias	 help(fitted.values.nlr)
	## alias	 help(residuals.nlr)
	## alias	 help(weights.nlr)

##___ Examples ___:

x <- c(3,5,0,0,0,3,2,2,2,7,4,0,0,2,2,2,0,1,3,4)
y <- c(-26,-191,2,1,10,-25,9,0,-8,-598,-80,3,-4,-7,-10,-22,-5,-8,-52,-84)
# 2*x^2-2*x^3+rnorm(20,0,10)
# linear regression
mu1 <- function(p) p[1]+p[2]*x
summary(lm(y~x))
nlr(y, mu=mu1, pmu=c(3,2))
# or
nlr(y, mu=~x, pmu=c(3,2))
# or
nlr(y, mu=~b0+b1*x, pmu=c(3,2))
# nonlinear regression
mu2 <- function(p) p[1]*x^p[2]+p[3]*x^p[4]
nlr(y, mu=mu2, pmu=c(1,1,-1,2))
# or
nlr(y, mu=~b0*x^b1+c0*x^c1, pmu=list(b0=1,b1=1,c0=-1,c1=2))
# with gamma distribution
y <- rgamma(20,2,0.2+2*exp(0.1*x))
nlr(y, dist="gamma", mu=~b0+c0*exp(c1*x),
	pmu=list(b0=0.2,c0=3,c1=0.2))



