###--- >>> `ssanova' <<<----- Fitting Smoothing Spline ANOVA Models

##___ Examples ___:

## Fit a cubic smoothing spline
x <- runif(100); y <- 5 + 3*sin(2*pi*x) + rnorm(x)
cubic.fit <- ssanova(y~x,method="m")

## The same fit with different internal makes
tp.fit <- ssanova(y~x,"tp",method="m")

## Obtain estimates and standard errors on a grid
new <- data.frame(x=seq(min(x),max(x),len=50))
est <- predict(cubic.fit,new,se=TRUE)

## Plot the fit and the Bayesian confidence intervals
plot(x,y,col=1); lines(new$x,est$fit,col=2)
lines(new$x,est$fit+1.96*est$se,col=3)
lines(new$x,est$fit-1.96*est$se,col=3)

## Keywords: 'ssanova', 'model', 'regression', 'smoothing', 'spline'.


