###--- >>> `integrate' <<<----- Adaptive Integration in 1--20 Dimensions.

	## alias	 help(adapt)
	## alias	 help(integrate)
	## alias	 help(print.integrate)

##___ Examples ___:

integrate(dnorm,-1.96,1.96)
##-	   value       relerr	    minpts	 lenwrk	       ifail
##-    0.9500042 0.0003456134	       125	     73		   0

normloc <- function(x,mu) dnorm(x-mu)
integrate(normloc,-1.96,1.96, mu=0) # passing 'mu' arg. to  normloc()
integrate(normloc,-2.96,0.96, mu=-1)

## Example of a three dimensional spherical normal distribution:
ir2pi <- 1/sqrt(2*pi)
fred <- function(z) { ir2pi^length(z) * exp(-0.5 * sum(z * z))}
adapt(3, c(-2,-2,-2),c(2,2,2),100,500,fred,.01)
##-	   value       relerr	    minpts	 lenwrk	       ifail
##-    0.8691984 2.579652e-05	       345	     54		   0
##
## i.e., it took 345 function evaluations to find the integral.
      adapt(3, c(-2,-2,-2),c(2,2,2),100,NULL,fred,.00001)
##       value       relerr       minpts       lenwrk        ifail 
##   0.8696159 1.902895e-06         5073          804            0
##  ie 5073 points needed (4 doublings).

## Keywords: 'math', 'utilities'.


