###--- >>> `catmiss' <<<----- Marginal probabilities for categorical repeated measures with missing data

##___ Examples ___:

y <- rpois(27,15)
r1 <- gl(3,1,27)
r2 <- gl(3,3,27)
r3 <- gl(3,9)
# r1, r2, and r3 are factor variables with 3 indicating missing
# independence model with three binary repeated measures
# with missing values
print(z <- glm(y~r1+r2+r3, family=poisson))
# obtain marginal estimates (no observations with 3 missing values)
resp <- cbind(codes(r1), codes(r2), codes(r3))[1:26,]
resp <- ifelse(resp==3, NA, resp)
catmiss(resp, y[1:26])



