###--- >>> `ar' <<<----- Fit Autoregressive Models to Time Series

	## alias	 help(ar)
	## alias	 help(ar.burg)
	## alias	 help(ar.burg.default)
	## alias	 help(ar.burg.mts)
	## alias	 help(ar.yw)
	## alias	 help(ar.yw.default)
	## alias	 help(ar.yw.mts)
	## alias	 help(ar.mle)
	## alias	 help(print.ar)
	## alias	 help(predict.ar)

##___ Examples ___:

data(lh)
ar(lh)
ar(lh, method="burg")
ar(lh, method="ols")
ar(lh, F, 4) # fit ar(4)

data(LakeHuron)
ar(LakeHuron)
ar(LakeHuron, method="burg")
ar(LakeHuron, method="ols")

data(sunspot)
sunspot.ar <- ar(sunspot.year)
sunspot.ar
ar(x = sunspot.year, method = "burg")
ar(x = sunspot.year, method = "ols")
##Don't run: ## next is slow and may have convergence problems,
##D ## as it cares about invertibility
##D ar(x = sunspot.year, method = "mle")

predict(sunspot.ar, n.ahead=25)

data(BJsales)
ar(ts.union(BJsales, BJsales.lead))
## Burg is quite different here, as is OLS (see ar.ols)
ar(ts.union(BJsales, BJsales.lead), method="burg")

## Keywords: 'ts'.


