

ts.plot {ts}                                 R Documentation

_P_l_o_t _M_u_l_t_i_p_l_e _T_i_m_e _S_e_r_i_e_s

_D_e_s_c_r_i_p_t_i_o_n_:

     Plot several time series on a common plot. Unlike
     `plot.ts' the series can have a different time bases,
     but they should have the same frequency.

_U_s_a_g_e_:

     ts.plot(..., gpars=list())

_A_r_g_u_m_e_n_t_s_:

     ...: one or more univariate or multivariate time series

   gpars: list of named graphics parameters to be passed to
          the plotting functions

_V_a_l_u_e_:

     None.

_N_o_t_e_:

     Although this can be used for a single time series,
     `plot' is easier to use and is preferred.

_A_u_t_h_o_r_(_s_)_:

     B.D. Ripley

_S_e_e _A_l_s_o_:

     `plot.ts'

_E_x_a_m_p_l_e_s_:

     data(UKLungDeaths)
     ts.plot(ldeaths, mdeaths, fdeaths,
             gpars=list(xlab="year", ylab="deaths", lty=c(1:3)))

     data(nottem)
     nott <- window(nottem, end=c(1936,12))
     fit <- arima0(nott,order=c(1,0,0), list(order=c(2,1,0), period=12))
     nott.fore <- predict(fit, n.ahead=36)
     ts.plot(nott, nott.fore$pred, nott.fore$pred+2*nott.fore$se,
             nott.fore$pred-2*nott.fore$se, gpars=list(col=c(1,1,4,4)))

