###--- >>> `white.test' <<<----- White Neural Network Test for Nonlinearity

	## alias	 help(white.test)
	## alias	 help(white.test.ts)
	## alias	 help(white.test.default)

##___ Examples ___:

n <- 1000

x <- runif (1000, -1, 1)  # Non-linear in "mean" regression 
y <- x^2 - x^3 + 0.1*rnorm(x)
white.test (x, y)

white.test (cbind(x,x^2,x^3), y)  # Is the polynomial of order 2 misspecified?

x[1] <- 0.0
for (i in (2:n))  # Generate time series which is nonlinear in "mean"
{
  x[i] <- 0.4*x[i-1] + tanh(x[i-1]) + rnorm (1, sd=0.5)
}
x <- as.ts(x)
plot (x)
white.test (x)

## Keywords: 'ts'.


