###--- >>> `xmp11.05' <<<----- data from Example 11.5

	## alias	 help(xmp11.05)

##___ Examples ___:

data(xmp11.05)
xmp11.05$brand <- factor(xmp11.05$brand)
xmp11.05$humid <- ordered(xmp11.05$humid)
plot(power ~ humid, data = xmp11.05, col = "lightgray",
     xlab = "Level of humidity",
     ylab = "Estimated annual power consumption (kwh)",
     main = "Data from Example 11.5")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 1, col = 2, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 2, col = 3, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 3, col = 4, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 4, col = 5, type = "b")
lines(power ~ as.integer(humid), data = xmp11.05,
        subset = brand == 5, col = 6, type = "b")
legend(0.6, 1010, paste("Brand", 1:5), col = 1 + (1:5),
       lty = 1)
fm1 <- lm(power ~ humid + brand, data = xmp11.05)
anova(fm1)    # compare with Table 11.3, page 442
summary(fm1)

## Keywords: 'datasets'.


