###--- >>> `.Alias' <<<----- Create Alias (Pointer) to R Object

	## alias	 help(.Alias)

##___ Examples ___:

mop <- options()
mop$browser <- "a browser"   # not set on all platforms
Op <- .Alias(mop)
## A change to mop is reflected in Op and vice versa
## -- ONLY if no new slots are created ...
mop$digits <- "Wow!"
Op$browser <- "another one"
mop$browser; Op$digits
all(names(mop) == names(Op) &
    sapply(seq(mop), function(i) all(Op[[i]] == mop[[i]])))
##> TRUE -- Op and mop ARE the same thing !

mop$newslot <- pi #--->> 'newslot' ==> (shallow) COPY of 'mop'
Op$newslot # R: still the old one, i.e. NULL
all(names(mop) == names(Op))# no longer TRUE

## Feel the power: `call by reference', a function modifying its argument:
tst.Al <- function(x) {
   y <- .Alias(x) ; attributes(y) <- NULL ; invisible()
}
(x0 <- structure(1:5, my.att = "Y"))
tst.Al(x0) # *changes* x0 :
x0
stopifnot(is.null(attributes(x0)))

## Keywords: 'programming'.


