###--- >>> `dist' <<<----- Distance Matrix Computation

	## alias	 help(dist)
	## alias	 help(print.dist)
	## alias	 help(format.dist)
	## alias	 help(as.matrix.dist)
	## alias	 help(names.dist)
	## alias	 help(names<-.dist)
	## alias	 help(as.dist)

##___ Examples ___:

x <- matrix(rnorm(100), nrow=5)
dist(x)
dist(x, diag = TRUE)
dist(x, upper = TRUE)
m <- as.matrix(dist(x))
d <- as.dist(m)
print(d, digits = 3)

## example of binary and canberra distances.
x <- c(0, 0, 1, 1, 1, 1)
y <- c(1, 0, 1, 1, 0, 1)
dist(rbind(x,y), method="binary")
## answer 0.4 = 2/5
dist(rbind(x,y), method="canberra")
## answer 2 * (6/5)

## Keywords: 'multivariate', 'cluster'.


