bk.points <- function(point.obj,
                      at,
                      prior,
                      var.mod.obj,
                      x,y,
                      maxdist = NULL,
                      extrap  = FALSE,
                      border  = NULL,
                      trend   = 0,
                      rsearch = 0,
                      nsearch = 0,
                      nsmin   = -1,
                      nsmax   = -1,
                      mode    = 3,
                      duplicate = "error",
                      dupfun = NULL,
                      method  = "gqr")
  {

    point.obj <- remove.duplicates(point.obj,at,duplicate,dupfun)
    tmp       <- check.krigedata(point.obj,at,var.mod.obj,mode)
    n         <- tmp$n

    
    npts    <- length(x)
    if(length(y)!=npts)
      stop("x and y have different lenght!")
    
    tmp     <- check.searchparams(maxdist,rsearch,nsearch,nsmin,nsmax,n)
    rsearch <- tmp$rsearch
    nsmin   <- tmp$nsmin
    nsmax   <- tmp$nsmax
    
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    cov0<-0
    covmat<-matrix(0,n,n)

    #   determine optimum array sizes:
    if(!is.null(method)){
        if(method!="gqr" && method!="direct" && method!="ols")
            stop("method (used for glsfit) should be one of \"gqr\", \"ols\" or \"direct\"!")
    } else {
        method <-"gqr"
    }
    method<-switch(method,direct=2,gqr=1,ols=0)    
#    lwork <- glsfit.workquery(n,ntrend,method)
    lwork <- 3000
    
    if(prior$ntr!=ntrend)
        stop("model order of priors does not match!")
    npr<-prior$n
    typpr<-prior$info
    typpr[prior$type=="subjective"]<-typpr[prior$type=="subjective"]*(-1)


        
    snbbit<-rep(0,1+n*npts)
    snbbit[1]<-1
    
    
    dopts<-check.border.points(extrap,x,y,npts,border,point.obj)

    ans<-.C("bk_point",
            xp     = as.double(x),
            yp     = as.double(y),
	    zp     = double(npts),
            varp   = double(npts),
	    dop     = as.integer(dopts),
            np      = as.integer(npts),
            lon     = as.double(point.obj$x),
            lat     = as.double(point.obj$y),
            z       = as.double(point.obj[[match(at, names(point.obj))]]),
	    extrap  = as.integer(extrap),
	    n       = as.integer(n),
	    covtype = as.integer(covtype),
            covpar  = as.double(var.mod.obj$parameters),
	    trend   = as.integer(trend),
	    ntrend  = as.integer(ntrend),
            mupr    = as.double(matlist.cbind(prior$mu)),
            ldmpr   = as.integer(ntrend),
            phipr   = as.double(matlist.cbind(prior$phi)),
            ldphpr  = as.integer(ntrend),
            lonpr   = as.double(prior$lon),
            latpr   = as.double(prior$lat),
            npr     = as.integer(npr),
            typpr   = as.integer(typpr),
            rsearch = as.double(rsearch),
	    nsearch = as.integer(nsearch),
	    nsmin   = as.integer(nsmin),
	    nsmax   = as.integer(nsmax),
            lwork   = as.integer(lwork),
            mode    = as.integer(mode),
            lambda  = double(n*npts),
            lambd0  = double(npts),
            bits    = as.integer(c(integer(npts),snbbit)),
            ierr    = integer(1),
            glsmth  = as.integer(method),
#           ,.Package= "baykrig"
            )
    
    
#    ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
#                     at,covmat,c0vec,c0,trend,rsearch,nsmin,nsmax,mode)
    retval<-list(x=ans$xp,
                 y=ans$yp,
                 z=ans$zp,
                 var=ans$varp,
                 done=ans$dop,
#                 snb=matrix(ans$bits[(npts+2):(nz+n*npts+1)],nrow=n,ncol=npts,byrow=F),
                 lambda=matrix(ans$lambda,nrow=n,ncol=npts,byrow=FALSE),
                 lambda0=ans$lambd0
                 )
    retval$z[retval$done<=0] <- NA
    retval$var[retval$done<=0] <- NA
    retval$lambda0[retval$done<=0] <- NA
    retval$data<-point.obj
    retval$at<-at
    retval
  }

