print.bk.prior<-function(x){

  if(!inherits(x,"bk.prior"))
    stop("argument is not member of class \"bk.prior\"!")
  
  cat("Prior Knowledge Object used for Bayesian Kriging\n")
  cat("\n")
  cat("Number of priors:", x$n,"\n\n")
  for(i in 1:x$n){
    cat("prior ",i,"\n")
    cat("  type is ", x$type[i],"\n")
    if(x$type[i]=="empirical"){
      cat("  based on an additional dataset of size", x$info[i],"\n\n")
    }
    cat("prior guess for regression parameter:\n")
    print(x$mu[[i]])    
    cat("\nprior covariance for regression parameter:\n")
    print(x$phi[[i]])
    cat("\n\n")
  }
}
