      SUBROUTINE BK(LON0,
     .              LAT0,
     .              DO0,
     .              INDDO,
     .              N0,
     .              LON,
     .              LAT,
     .              Z,
     .              N,
     .              COVTYPE,
     .              COVPAR,
     .              COVMAT,
     .              LDCOV,
     .              C0VEC,
     .              LDC0,
     .              COV0,
     .              TREND,
     .              NTREND,
     .              MUPR,
     .              LDMPR,
     .              PHIPR,
     .              LDPHPR,
     .              MUWRK,
     .              PHIWRK,
     .              LDPHWK,
     .              LONPR,
     .              LATPR,
     .              BETA,
     .              ERRBTA,
     .              COVBTA,
     .              LDCVBT,
     .              DEV,
     .              ERRDEV,
     .              CVSRNB,
     .              ZSRNB,
     .              NPR,
     .              TYPPR,
     .              RSEARCH,
     .              NSEARCH,
     .              NSMIN,
     .              NSMAX,
     .              FWORK,
     .              FWRK2,
     .              LDFWRK,
     .              F0WORK,
     .              LDF0WK,
     .              DIST,
     .              INDSNB,
     .              INDSNW,
     .              INDSRT,
     .              KWORK,
     .              LDKWRK,
     .              RHSWORK,
     .              FPWORK,
     .              FPFWORK,
     .              FPF0WRK,
     .              CHLUP,
     .              LDCLUP,
     .              CMINV,
     .              LDCINV,
     .              WORK,
     .              LWORK,
     .              IPVT,
     .              FERR,
     .              BERR,
     .              IPIV,
     .              IWORK,
     .              MODE,
     .              MU,
     .              LDMU,
     .              Z0,
     .              NA0,
     .              LAMBDA,
     .              LDLMBD,
     .              LAMBD0,
     .              VAR0,
     .              SNBBIT,
     .              USESBBT,
     .              IERR,
     .              GLSMTH)      
      
      IMPLICIT NONE
      INTEGER N,TREND,NTREND,MODE,IERR,NSEARCH,NSMIN,NSMAX,IPIV(*),
     .        INDSNB(*),INDSNW(*),INDSRT(*),COVTYPE,DO0(*),INDDO(*),
     .        NA0(*),LDCOV,LDC0,LDFWRK,LDLMBD,LDKWRK,N0,
     .        NPR,TYPPR(*),LWORK,IPVT(*),IWORK(*),GLSMTH,
     .        LDCVBT,LDCLUP,LDCINV,
     .        LDMPR,LDPHPR,LDPHWK,                                       LDPRIV
     .        LDF0WK,LDRSWK,LDMU,USESBBT,SNBBIT(*)
      DOUBLE PRECISION LAT0(*),LON0(*),LAT(*),LON(*),Z(*),
     .                 COVMAT(LDCOV,*),C0VEC(LDC0,*),COV0,COVPAR(3),
     .                 FWORK(LDFWRK,*),F0WORK(LDF0WK,*),MU(LDMU,*),
     .                 Z0(*),LAMBDA(LDLMBD,*),VAR0(*),FWRK2(LDFWRK,*),
     .                 RSEARCH,KWORK(LDKWRK,*),RHSWORK(LDKWRK,*),
     .                 FPWORK(LDFWRK,*),FPFWORK(LDFWRK,*),
     .                 FPF0WRK(LDFWRK,*),DIST(*),MUPR(LDMPR,*),
     .                 PHIPR(LDPHPR,*),LAMBD0(*),PHIWRK(LDPHWK,*),
     .                 LONPR(*),LATPR(*),MUWRK(*),                       PRINV(LDPRIV,*),
     .                 BETA(*),COVBTA(LDCVBT,*),
     .                 WORK(LWORK),
     .                 CHLUP(LDCLUP,*),CMINV(LDCINV,*),DEV(*),
     .                 CVSRNB(LDCOV,*),ZSRNB(*),ERRDEV,ERRBTA,
     .                 FERR(*),BERR(*)

c     subroutine for universal bayesian kriging
c
c     This subroutine solves a kriging system for n0 prediction points 
c     simultaneously. It first finds the superset of all search
c     neighbourhoods, selects the apropriate submatrix from COVMAT, determines
c     the covariance vectors C0VEC for each prediction point, builds the 
c     design matrix FWORK and the design vectors F0WORK and then solves a 
c     linear system with multiple right hand sides (DGESV).
c
c     This routine is meant to be called from BKGRID, which builds small
c     blocks (tiles) from a grid and sends them to KRIGE for simultaneous
c     computation.
c
c     input:                                                             dim:
c     LAT0,LON0  coordinates of prediction point(s) x_0              (n0 x 1)
c     N0         number of prediction points 
c     DO0        0/1 indicator which points to use                   (n0 x 1)
c                (used by BKGRID for restricting output to convex hull)
c     LAT,LON    coordinates of data points x_i                       (n x 1)
c     Z          data values                                          (n x 1)
c     N          number of data points
c     COVTYPE    type of covariance function (1-exp,2-gauss,3-spher,4-linear)
c     COVPAR     covariance function parameters (nugget, sill, range) (3 x 1)
c     COVMAT     covariance matrix = C(x_i,x_j)                       (n x n)
c     LDCOV      leading dimension of COVMAT
c     C0VEC      covariance vector(s) = C(x_i,x_0)                   (n x n0)
c     LDC0       leading dimension of COVEC
c     COV0       variance = C(0)
c     TREND      order of trend             (0,1,2)
c     NTREND     number of trend parameters (1,3,6)
c     MUPR       prior guess(es) for trend parameter           (ntrend x npr)
c     PHIPR      prior cov matrix(/ces) of MUPR         (ntrend x ntrend*npr)
c     PRINV      inv prior cov matrix(/ces) of MUPR     (ntrend x ntrend*npr)
c     LONPR,LATPR locations accociated to priors                    (npr x 1)
c     NPR        no of priors
c     TYPPR      array containing type of priors                    (npr x 1) 
c                  >0: empirical prior, indicates size of additional data set
c                  <0: subjective prior, indicates type of distribution
c     RSEARCH    fixed search radius
c     NSEARCH    fixed number of points in search neighbourhood
c     NSMIN      min number of points in search neighbourhood
c     NSMAX      max number of points in search neighbourhood
c     FWORK      work array for design matrix                    (n x ntrend)
c     LDFWRK     leading dimension of FWORK 
c     F0WORK     work array for design vector(s)                (ntrend x n0)
c     MODE       operation mode:
c                1: predict only z0 at (lon0,lat0)
c                   calculates z0, mu and lambda
c                2: calculate only prediction variance
c                   calculates var, mu, and lambda (z is NOT used!)
c                3: both
c                   calculates z0, var, mu, and lambda
c
c     work arrays and local variables:
c     DIST       distance vector for search neighbourhood             (n x 1)
c     INDSNB     index vector for search neighbourhood                (n x 1)
c     INDSNW     work index for search neighbourhood                  (n x 1)
c     INDSRT     index vector for sorted search neighbourhood         (n x 1)
c     KWORK      krige matrix                                         (n x n)
c     LDKWRK     leading dim of KWORK 
c     RHSWORK    right hand side                                     (n x n0)
c     NS         actual size of search neigbourhood
c     INDDO      work array, holds the indices where DO0=1           (n0 x 1)
c     MUWRK      working copy of prior trend parameter           (ntrend x 1)
c     PHIWRK     working copy of prior cov matrix           (ntrend x ntrend)
c     FPWORK     temp. work arrays                               (n x ntrend)
c     FPFWORK                                                         (n x n)
c     FPF0WRK                                                        (n x n0)
c     IPIV       working array for DGESV                              (n x 1)
c     IPVT       working array for DGEFA                         (ntrend x 1)
c     BETA       gls estimator in search neighbourhood           (ntrend x 1)
c     COVBTA     cov matrix of BETA                         (ntrend x ntrend)
c     CVSRNB     working copy of cov (sub)matrix                      (n x n)
c     ZSRNB      working copy of Z for search neighbourhood           (n x 1)
c     IWORK      used in GLSFIT                                      (3n x 1)
c
c     output:
c     MU         langrange parameter (=est. trend parameter)    (ntrend x n0)
c     Z0         predicted value
c     NA0        0/1 indicator where kriging failed                  (n0 x 1)
c     VAR0       kriging variance                                    (n0 x 1)
c     LAMBDA     kriging weights                                     (n x n0)
c     LDLMBD     leading dim of LAMBDA
c     LAMBD0     bias term(s)                                        (n0 x 1)
c     IERR       error code
c
c     solves the bayes krige system (with n0>=1 right hand sides / solutions):
c
c     [COVMAT + FWORK*PHIPR*FWORK'] * LAMBDA = C0VEC + FWORK*PHIPR*F0WORK 
c      LAMBD0 = [ F0WORK' - LAMBDA'*FWORK ] * MUPR
c
c     Z0   = LAMBDA'*Z + LAMBD0
c     VAR0 = COV0 + F0WORK*PHIPR * F0WORK' - LAMBDA'*(C0VEC+FWORK*PHIPR*F0WORK) 

c     external functions
      DOUBLE PRECISION DDOT, COVFN
      EXTERNAL DDOT, COVFN

c     external subroutines
      EXTERNAL SRCHNB, DESIGN, GLSFIT, DGEMM, DGEMV, DGESV

c     local variables
      INTEGER I,J,INFO,NS,K,NEMP,NDO
      DOUBLE PRECISION SGSQR

c     local constants
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D0, ZERO = 0.0D0 )

c     debug options
      CHARACTER*16 NAME
      INTEGER DBGLVL
      COMMON /DEBUG/ DBGLVL
      dbglvl=1
      IERR=0

c     some checks
      IF (MODE.NE.1 .AND. MODE.NE.2 .AND. MODE.NE.3) THEN
         IERR=1
         RETURN
      END IF
      IF (NSMIN.LT.0 .OR. NSMIN.GT.N) THEN
         NSMIN=0
      END IF
      IF (NSMAX.LT.0 .OR. NSMAX.GT.N) THEN
         NSMAX=N
      END IF
c     omit points with do0=0
c      name="do0"
c      call imatpr(do0,n0,1,n0,name,dbglvl)

      I=0
      J=0
      NDO=0
 3000 I=I+1
      IF (DO0(I).EQ.0) GO TO 3001
      J=J+1
      NDO=J
      INDDO(J)=I
 3001 IF (I.LT.N0) GO TO 3000
      
      IF (NDO.EQ.0) THEN 
         RETURN
      END IF

      
c     determine search neighbourhood
      CALL SRCHNB(LON0,LAT0,DO0,INDDO,N0,NDO,LON,LAT,N,NS,
     .            RSEARCH,NSEARCH,NSMIN,NSMAX,
     .            INDSRT,INDSNB,INDSNW,DIST)
c      write(*,*)"SEARCHNB is:",NS
      if (usesbbt.ne.0) then
         do 1212 i=1,n
            if (indsnb(i).ne.0) then
               snbbit(indsnb(i))=1
            else
               snbbit(indsnb(i))=0
            end if
 1212    continue
      end if

c     prepare the design matrix
      CALL DESIGN(LON,LAT,N,INDSNB,NS,LON0,LAT0,N0,INDDO,NDO,
     .            FWORK,LDFWRK,F0WORK,LDF0WK,NTREND,TREND,IERR)

c     make a copy in fwrk2
      CALL DESIGN(LON,LAT,N,INDSNB,NS,LON0,LAT0,N0,INDDO,NDO,
     .            FWRK2,LDFWRK,F0WORK,LDF0WK,NTREND,TREND,IERR)

c      CALL DSUBMM(FWORK,NS,NTREND,1,1,NS,NTREND,LDFWRK,FWRK2,LDFWRK,1)
c     extract appropriate parts of covariance matrix and Z
      DO 10 I=1,NS
         ZSRNB(I)=Z(INDSNB(I))
         DO 11 J=1,NS
            CVSRNB(I,J)=COVMAT(INDSNB(I),INDSNB(J))
 11      CONTINUE
 10   CONTINUE



c     do (generalised) least squares fit in search neighbourhood
c      CALL GLSFIT(FWORK,N,NTREND,LDFWRK,ZSRNB,CVSRNB,LDCOV,BETA,U,
c     .            COVBTA,CHLUP,CMINV,WORK1,WORK,LWORK,IPVT,IWORK,IERR)
      IF (GLSMTH.EQ.0) THEN
         CALL LSFIT(FWORK,FWRK2,NS,NTREND,LDFWRK,ZSRNB,BETA,
     .               ERRBTA,DEV,ERRDEV,
     .               COVBTA,LDCVBT,SGSQR,
     .               CMINV,LDCINV,
     .               KWORK,LDKWRK,FPFWORK,LDFWRK,
     .               FERR,BERR,WORK,LWORK,IPVT,IPIV,IWORK,IERR)
         IF ( IERR .NE. 0 ) THEN 
            DO 1011 I=1,N0
               NA0(I)=1
 1011       CONTINUE
            CALL ERRMSG('BK LSFIT: error',16,IERR)
            RETURN
         END IF
      ELSE
c         CALL GLSFIT(FWORK,FWRK2,NS,NTREND,LDFWRK,ZSRNB,CVSRNB,LDCOV,
         CALL GLSFIT(FWORK,FWRK2,NS,NTREND,LDFWRK,ZSRNB,CVSRNB,LDCOV,
     .               BETA,ERRBTA,DEV,ERRDEV,
     .               COVBTA,LDCVBT,SGSQR,
     .               CHLUP,LDCLUP,CMINV,LDCINV,
     .               KWORK,LDKWRK,FPFWORK,LDFWRK,
     .               FERR,BERR,WORK,LWORK,IPVT,IPIV,IWORK,IERR,GLSMTH)
         IF ( IERR .NE. 0 ) THEN 
            DO 1010 I=1,N0
               NA0(I)=1
 1010       CONTINUE
            CALL ERRMSG('BK GLSFIT: error',16,IERR)
            RETURN
         END IF
c      name="beta\0"
c      call matpr(name,beta,ntrend,1,ntrend,1)
c      name="covbta\0"
c      call matpr(name,covbta,ntrend,ntrend,ntrend,1)
      END IF

ccc      goto 123



c     merge priors with search neighbourhood:
c     average all prior guesses with estimation in search neighbourhood
      DO 18 I=1,NTREND
         MUWRK(I)=BETA(I)
         DO 17 J=1,NPR
            MUWRK(I)=MUWRK(I)+MUPR(I,J)
 17      CONTINUE
         MUWRK(I)=MUWRK(I)/(NPR+ONE)
 18   CONTINUE

c     mix prior cov matrices and estimation in search neighbourhood
c                                                 vv MUPR(I,J) ??
      DO 30 I=1,NTREND
         DO 31 J=1,NTREND
            PHIWRK(I,J)=(BETA(I)-MUWRK(I))*(BETA(J)-MUWRK(J))/NPR -
     .                  COVBTA(I,J)/(1*(NPR+1))                             ! *NS
 31      CONTINUE
 30   CONTINUE
      DO 32 K=1,NPR
         IF (TYPPR(K).GT.0) THEN
            NEMP=TYPPR(K)
         ELSE
            NEMP=1
         END IF
         DO 33 I=1,NTREND
            DO 34 J=1,NTREND
               PHIWRK(I,J)=PHIWRK(I,J)+
     .                     (MUPR(I,K)-MUWRK(I))*(MUPR(J,K)-MUWRK(J))
     .                     /NPR 
     .                     -                                                !!!!!!!! -
     .                     PHIPR(I,J+(K-1)*NTREND)/(1*(NPR+1))              ! *NEMP
 34         CONTINUE
 33      CONTINUE
 32   CONTINUE
c      name="phiwrk\0"
c      call matpr(name,phiwrk,ntrend,ntrend,LDphwk,dbglvl)



c     prepare the design matrix once more, it was destroyed by GLSFIT
c     ????????????????
      CALL DESIGN(LON,LAT,N,INDSNB,NS,LON0,LAT0,N0,INDDO,NDO,
     .            FWORK,LDFWRK,F0WORK,LDF0WK,NTREND,TREND,IERR)

c     start preparing the bayesian kriging matrices:
c     calculate FPWORK = FWORK * PHIWRK 
c                        n x nt  nt x nt
      CALL DGEMM('N','N',N,NTREND,NTREND,ONE,FWORK,LDFWRK,PHIWRK,
     .           LDPHWK,ZERO,FPWORK,LDFWRK)

c     calculate FPFWORK = FWORK * PHIWRK * FWORK'
c                             n x nt       nt x n
      CALL DGEMM('N','T',N,N,NTREND,ONE,FPWORK,LDFWRK,FWORK,
     .           LDFWRK,ZERO,FPFWORK,LDFWRK)

c     calculate FPF0WRK = FWORK * PHIWRK * F0
c                             n x nt       nt x n0
      CALL DGEMM('N','N',N,N0,NTREND,ONE,FPWORK,LDFWRK,F0WORK,LDF0WK,
     .           ZERO,FPF0WRK,LDFWRK)
 
c     prepare the covariance vector(s)
      IF (COVTYPE.NE.0) THEN
         COV0=COVPAR(1)+COVPAR(2)
         DO 1000 I=1,N
            DO 1001 J=1,NDO
               C0VEC(I,INDDO(J))=COVFN(COVTYPE,COVPAR,
     .                        SQRT((LON(I)-LON0(INDDO(J)))
     .                              *(LON(I)-LON0(INDDO(J)))+
     .                             (LAT(I)-LAT0(INDDO(J)))
     .                              *(LAT(I)-LAT0(INDDO(J)))))
 1001       CONTINUE
 1000    CONTINUE
      END IF

c     prepare the krige matrix
c      name="cov"
c      call matpr(covmat,n,n,n,name,dbglvl)
      DO 20 I=1,NS
         DO 21 J=1,NS
            KWORK(I,J)=COVMAT(INDSNB(I),INDSNB(J))+FPFWORK(I,J)
c            write(*,*) i,j,kwork(i,j)
 21      CONTINUE
 20   CONTINUE
c     prepare the right hand side(s)
      DO 300 J=1,NDO
         DO 40 I=1,NS
            RHSWORK(I,J)=C0VEC(INDSNB(I),inddo(J))+FPF0WRK(I,j)
 40      CONTINUE
 300  CONTINUE
      
c     solve the system
c     LAMBDA = (C0VEC+FWORK*PHIPR*F0WORK)*(COVMAT+FWORK*PHIPR*FWORK')^-1
c      name="kwork\0"
c      call matpr(name,kwork,ns,ns,LDkwrk,dbglvl)
c      name="rhswork\0"
c      call matpr(name,rhswork,ns,NDO,LDkWrk,dbglvl)
C     BETTER USE DSYSVX ?

      CALL DGESV(NS,NDO,KWORK,LDKWRK,IPIV,RHSWORK,LDKWRK,INFO)
c      name="lsg"
c      call matpr(rhswork,ns,NDO,nkwork,name,dbglvl)

      DO 3334 I=1,NDO
         NA0(I)=0
 3334 CONTINUE
      
      IF (INFO.NE.0) THEN
         IERR=INFO
         DO 3333 I=1,NDO
            NA0(I)=1
 3333    CONTINUE
         RETURN
      END IF

c     extract optimal weights
      DO 401 J=1,N0
         DO 52 I=1,N
            LAMBDA(I,J)=0
 52      CONTINUE
 401  CONTINUE
      DO 400 J=1,NDO
         DO 50 I=1,NS
c            write (*,*)i,indsnb(i),j
            LAMBDA(INDSNB(I),INDDO(J))=RHSWORK(I,J)
c            write (*,*)LAMBDA(INDSNB(I),INDDO(J))
 50      CONTINUE
         
 400  CONTINUE
c     determine bias term(s) (LAMBD0 is a vector, length N0!)
c     LAMBD0 = (F0WORK-FWORK'*LAMBDA)' * MUWRK
c     need only srnb parts of lambda, still in rhswork
c     we use MU as work array
      DO 411 I=1,NTREND
         DO 412 J=1,NDO
            MU(I,J)=F0WORK(I,J)
 412     CONTINUE
 411  CONTINUE
      CALL DGEMM('T','N',NTREND,NDO,NS,-ONE,FWORK,LDFWRK,RHSWORK,LDKWRK,
     .           ONE,MU,LDMU)
      CALL DGEMV('T',NTREND,NDO,ONE,MU,LDMU,MUWRK,1,ZERO,LAMBD0,1)
c      name="lambd0\0"
c      call matpr(name,lambd0,n0,1,n0,1)

c     MU=...

c     calculate variance #########anders
c      name="lambda"
c      call matpr(lambda,n,n0,n,name,dbglvl)
c      name="c0vec"
c      call matpr(c0vec,n,n0,n,name,dbglvl)
c      name="mu"
c      call matpr(mu,ntrend,n0,ntrend,name,dbglvl)
c      name="f0work"
c      call matpr(f0work,ntrend,NDO,ntrend,name,dbglvl)

c     VAR0 = COV0 + F0WORK' * PHIPR * F0WORK - LAMBDA'*C0VEC 
c     VAR0 = COV0 + F0WORK*PHIPR * F0WORK' - LAMBDA'*(C0VEC+FWORK*PHIPR*F0WORK) 
c     for more than one RHS in matrix notation 
c     (now LAMBDA and F0WORK are matrices)
c     VAR0 = [COV0] + diag(F0WORK' * PHIPR * F0WORK) - diag(LAMBDA'*((C0VEC+FWORK*PHIPR*F0WORK))
c                                                                    C0VEC) 

      IF (MODE.EQ.2 .OR. MODE.EQ.3) THEN
c            work array: RHSWORK = C0VEC + FWORK PHIPR F0WORK
c     the same procedure as to prepare the right hand side(s) above:
c     (use the same index sorting as in lambda!!)
      DO 1300 J=1,NDO
         DO 140 I=1,NS
            RHSWORK(indsnb(I),J)=C0VEC(INDSNB(I),inddo(J))+FPF0WRK(I,J)
 140     CONTINUE
 1300 CONTINUE
         DO 500  I=1,NDO
c           work array: MU = PHIPR * F0WORK
            CALL DGEMV('N',NTREND,NTREND,ONE,PHIWRK,LDPHWK,
     .                 F0WORK(1,I),1,ZERO,MU,1)        
c         write(*,*)"cov0:",cov0
c         name="mu\0"
c         call matpr(name,mu,ntrend,1,ldmu,dbglvl)
c         name="f0work\0"
c         call matpr(name,f0work,ntrend,1,ldf0wk,dbglvl)
c         name="phiwrk\0"
c         call matpr(name,phiwrk,ntrend,ntrend,ldphwk,dbglvl)
c         name="lambda\0"
c         call matpr(name,lambda(1,inddo(i)),n,1,ldlmbd,dbglvl)
c         name="c0vec\0"
c         call matpr(name,c0vec(1,inddo(i)),n,1,ldc0,dbglvl)
c         name="rhswork\0"
c         call matpr(name,rhswork(1,inddo(i)),n,1,ldkwrk,dbglvl)
              
            VAR0(INDDO(I)) = COV0 - DDOT(N,LAMBDA(1,INDDO(I)),
     .                                   1,RHSWORK(1,INDDO(I)),1)
     .                       + DDOT(NTREND,MU,1,
     .                              F0WORK(1,I),1)
 500     CONTINUE
      END IF

c     using KWORK and CMINV as work arrays
c      CALL DGEMM('T','N',N0,NTREND,ONE,F0WORK,LDFWRK,PHIWRK,LDPHWK,ZERO,
c     .           KWORK,LDKWRK)
c      CALL DGEMM('T','N',N0,N,ONE,LAMBDA,LDLMBD,COVEC,LDC0,ZERO,
c     .           CMINV,LDCINV)
c      CALL DGEMM( .... only diags needed - not better than do loops --^)
      
     
c     calculate predicted value(s)
c     name="z"
c     call matpr(z,n,1,n,name,dbglvl)
      IF (MODE.EQ.1 .OR. MODE.EQ.3) THEN
c        Z0 = LAMBDA' * Z + LAMBD0
         CALL DGEMV('T',N,N0,ONE,LAMBDA,LDLMBD,Z,1,ZERO,Z0,1)
         DO 501 I=1,N0
            Z0(I)=Z0(I)+LAMBD0(I)
 501     CONTINUE
      END IF
c      name="z0"
c      call matpr(z0,n0,1,n0,name,dbglvl)
c      write(*,*)"z: ",z0(1)
      IWORK(1)=NS
 123  continue
      RETURN
      END


