"bailey"<-
function(n, sigma = 0, stepsize = 0.10000000000000001, seed = 123, isam = 5, 
	start, pad = 500)
{
	if(missing(start)) {
		start <- c(0.10000000000000001, -1, 1)
		n <- n + pad
	}
	write(c(stepsize, n * isam, sigma, seed, isam, start), file = 
		"bailey.in", ncol = 1)
	unix("make.bailey.x < bailey.in > bailey.out")
	temp <- matrix(scan("bailey.out"), ncol = 4, byrow = T)
	if(missing(start))
		temp <- temp[ - (1:pad),  ]
	unix("rm bailey.in bailey.out")	
	#	dimnames(temp) <- list(NULL, c("T", "X", "Y", "Z"))
	list(t = temp[, 1], state.vector = temp[, 2:4], sigma = sigma)
}
