"cover.design.S"<-
function(R, nd, nruns = 1, nn = T, num.nn = 100, fixed = NULL, scale.type = 
	"range", R.center, R.scale, P = -20, Q = 20, start = NULL, DIST = NULL, 
	return.grid = T)
{
##
##BD group  prefers a default for scale.type that is better for designed 
## experiments: 
## scale.type = "range", 
##
## pdh 1/8/97: num.nn should not be greater than nrow(R), if it
##    is then set nn=F. Also added some error checking. Fixed a
##    problem in which fixed points could be included in the design
## pdh 12/10/96: changed default for num.nn=100, return
## nn and num.nn as attributes of out, reordered arguments
## to make the help function more orderly
## changed the defaults for P and Q
## R and nd have no defaults and so must be specified
## changed the name from c.design to cover.design
	if(!is.null(start) && is.matrix(start)) {
		if(any(dup.matrix(start)))
			stop("Error: start must not have duplicate rows")
		start <- rowmatch(start, R)
		if(any(is.na(start)))
			stop("Error: Starting design must be a subset of R")
	}
	R.orig <- R
	R <- as.matrix(R)
	if(any(dup.matrix(R)))
		stop("Error: R must not have duplicate rows")
	if(num.nn >= nrow(R))
		nn <- F
	if(is.null(DIST))
		DIST <- function(x, y)
		{
			rdist(x, y)
		}
	id <- 1:nrow(R)
	if(!is.null(start))
		nd <- length(start)
	if(is.null(fixed))
		n <- nd
	else {
		if(any(dup.matrix(fixed)))
			stop("Error: fixed must not have duplicate rows")
		if(is.matrix(fixed)) {
			fixed <- rowmatch(fixed, R)
			if(any(is.na(fixed)))
				stop(
				  "Error: fixed points must be included in R")
		}
		n <- nd + length(fixed)
	}
	R <- transformx(R, scale.type, R.center, R.scale)
	transform <- attributes(R)
	saved.crit <- rep(NA, nruns)
	saved.designs <- matrix(NA, nrow = nruns, ncol = n)
	saved.hist <- list()
	for(RUNS in 1:nruns) {
		if(is.null(start)) {
## modifications to keep fixed points from being
## included in start
			if(!is.null(fixed)) {
				Dset <- sample((1:nrow(R))[ - fixed], nd)
				Dset <- c(Dset, fixed)
			}
			else Dset <- sample(1:nrow(R), nd)
		}
		else {
			if(length(start) > nd)
				stop(
				  "Error: the start matrix must have nd rows")
			Dset <- start
			if(!is.null(fixed))
				Dset <- c(Dset, fixed)
		}
		design.original <- R[Dset,  ]
		Dset.orginal <- Dset
		Cset <- id[ - Dset]	##
## Dset and Cset are the indices that identify the design and candidate 
## sets Dset union Cset should be  1:nrow(R)
##
		dist.mat <- DIST(R[Cset,  ], R[Dset,  ])
		rs <- dist.mat^P %*% rep(1, n)	##
##
		crit.i <- crit.original <- sum(rs^(Q/P))^(1/Q)	## print(crit.i)
		CRIT <- rep(NA, length(Cset))
		CRIT.temp <- rep(NA, length(Cset))
		hist <- matrix(c(0, 0, crit.i), ncol = 3, nrow = 1)
		repeat {
			for(i in 1:nd) {
				Dset.i <- matrix(R[Dset[i],  ], nrow = 1)
				partial.newrow <- sum(DIST(Dset.i, R[Dset[ - i],
				  ])^P)
				rs.without.i <- rs - c(DIST(Dset.i, R[ - Dset,  
				  ])^P)
				if(nn)
				  vec <- (1:length(Cset))[order(dist.mat[, i])[
				    1:num.nn]]
				else vec <- 1:length(Cset)
				for(j in vec) {
## now swap the the jth candidate point with the ith design 
## point and recompute the coverage criterion. 
## there are some efficienies here because many of the distances 
## and sums do not change
##
				  Cset.j <- matrix(R[Cset[j],  ], nrow = 1)
				  newcol <- c(DIST(Cset.j, R[c( - Dset,  - Cset[
				    j]),  ])^P)	##
## sum over the rows for all the candidates excluding the jth one.
## adjust this sum by the new design point C[j]
##
## Note that rs.without.i are 
## the old row sums but excluding the old design point i.
##
				  CRIT[j] <- (sum((rs.without.i[ - j] + newcol)
		##
				  ^(Q/P))	##
## now add in the contribution from the j th row 
##  
 + (DIST(Cset.j, Dset.i)^P + partial.newrow)^(Q/P)	##
				  )^(1/Q)	## longer calculations for debugging:
##				  Dtemp <- D
##				  Ctemp <- C
##				  Dtemp[i] <- C[j]
##				  Ctemp[j] <- D[i]
##				  rtemp <- ((DIST(R[Ctemp,  ], R[Dtemp,  ])^P) %*% 
##				    rep(1, n))
##				  CRIT.temp[j] <- sum(rtemp^(Q/P))^(1/Q)
				}
				best <- min(CRIT[!is.na(CRIT)])
				best.spot <- Cset[CRIT == best][!is.na(Cset[
				  CRIT == best])][1]
				crit.old <- crit.i
				if(best < crit.i) {
				  crit.i <- best
				  hist <- rbind(hist, c(Dset[i], best.spot, 
				    crit.i))
				  Dset[i] <- best.spot
				  Cset <- id[ - Dset]
				  dist.mat <- DIST(R[Cset,  ], R[Dset,  ])
				  rs <- (dist.mat^P) %*% rep(1, n)
				}
##				cat(best, fill = T)
##				cat(Dset, fill = T)
			}
			if(crit.i == crit.old)
				break
		}
		saved.crit[RUNS] <- crit.i
		saved.designs[RUNS,  ] <- Dset
		saved.hist[[RUNS]] <- hist
	}
	ret <- (1:nruns)[saved.crit == min(saved.crit)]
	if(length(ret) > 1) {
		print("Greater than 1 optimal design; keeping first one......")
		ret <- ret[1]
	}
	crit.i <- saved.crit[ret]
	hist <- saved.hist[[ret]]
	nh <- nrow(hist)
	hist <- cbind(c(0:(nrow(hist) - 1)), hist)
	dimnames(hist) <- list(NULL, c("step", "swap.out", "swap.in", 
		"new.crit"))	
	## return a data frame with attributes rather than a list
	out.des <- R[saved.designs[ret,  ],  ]
	out.des <- unscale(out.des, transform$x.center, transform$x.scale)
	out <- data.frame(out.des)
	attr(out, "call") <- match.call()
	class(out) <- c("spatial.design", "data.frame", "matrix")
	attr(out, "best.id") <- c(saved.designs[ret,  ])
	attr(out, "fixed") <- fixed
	attr(out, "opt.crit") <- crit.i
	attr(out, "start.design") <- design.original
	attr(out, "start.crit") <- crit.original
	attr(out, "history") <- hist
	attr(out, "other.designs") <- saved.designs
	attr(out, "other.crit") <- saved.crit
	attr(out, "DIST") <- DIST
	attr(out, "nn") <- nn
	attr(out, "num.nn") <- num.nn
	if(return.grid)
		attr(out, "grid") <- R.orig
	attr(out, "transform") <- transform
	out
}
