"make.Amatrix.krig"<-
function(out, x0 = out$x, lambda)
{
	if(missing(lambda)) {
		lambda <- out$lambda
	}
	xc <- out$transform$x.center
	xs <- out$transform$x.scale
	xM <- scale(out$xM, xc, xs)
	knots <- scale(out$knots, xc, xs)
	x0 <- scale(x0, xc, xs)
	X <- cbind(make.tmatrix(xM, out$m), qr.yq2(out$matrices$qr.T, out$
		cov.function(xM, knots)))
	temp <- (out$matrices$G) %*% diag(1/(1 + lambda * out$matrices$D))
	temp <- temp %*% t(out$matrices$G) %*% t(X)
	temp <- temp %*% diag(out$weightsM)	#
#
# OK at this point temp maps YM to the beta vector of coefficients
#
	temp <- cbind(make.tmatrix(x0, out$m), matrix(qr.yq2(out$matrices$qr.T, 
		out$cov.function(x0, knots)), nrow = nrow(x0))) %*% temp	#
#
	return(temp)
}
