"mle.krig"<-
function(out, lambda = NA, cost = 1, nstep.cv = 40)
{
	names(out)	##     b= B*U( I + lambda*D)^(-1) U^T * B * X^T*Y
##      = G*( I + lambda*D)^(-1) G^T* X^T*Y
#
#
#
##   So now we have
#
##    b= G*( I + lambda*D)^(-1)*u
##   Note how in this form we can rapidly solve for b for any lambda
#
#
##   To find GCV function  need to identify the  hat matrix, A such that
##         yhat =   AY
#
## the rest of this part is evaluating the GCV function
#
##   From the above notation  A= X*G*(I+ lambda*D)^(-1)G*X^T
##   Need to calculate  V(lambda)= (1/n)||( I-A)Y||^2 / ( 1- tr(A)/n)^2
##
##   there are some shortcuts here based on the decompostion
#
##   From the definition of G   G^T*X^T*X*G = I
#
##   So tr(A)= tr( X*G*(I+ lambda*D)^(-1)G^T*X^T)
##           = tr((I+ lambda*D)^(-1)G^T*X^T*X*G)
##           = tr( (I+ lambda*D)^(-1)) = sum( 1/(1+ lambda*D_k))
#
##    Also the residual sum of squares=
##      ||( I-A)Y||^2 = pure.ss +
#        sum( (u_k)^2 {(lambda*D_k)/ ( 1+ lambda*D_k)}^2)
#
## Using the properties of G*X^T
##
##
##     create a reasonable vector of lambdas if it is missing
#
	nt <- out$nt
	np <- out$np
	N <- length(out$y)
	D <- out$matrices$D
	u <- t(out$matrices$G) %*% t(out$matrices$X) %*% (out$y * out$weights)
	if(length(u) < N) {
		pure.ss <- sum((out$y - out$matrices$X %*% out$matrices$G %*% u
			)^2)
	}
	else {
		pure.ss <- 0
	}
	if(is.na(lambda)) {
		l1 <- 1/D[np - nt - 1]
		tr <- np	########## find upper value of lambda
##########
		for(k in 1:8) {
			tr <- sum(1/(1 + l1 * D))
			if(tr < nt * 1.2)
				break
			l1 <- l1 * 2
		}
########## find lower lambda
##########
		l2 <- 1/D[1]
		for(k in 1:8) {
			tr <- sum(1/(1 + l2 * D))
			if(tr > np * 0.94999999999999996)
				break
			l2 <- l2/2
		}
		lambda <- exp(seq(log(l2), log(l1),  , nstep.cv))
	}
	nl <- length(lambda)
	ind <- D > 0
	nd <- length(D)	#
#
## In S the fastest way to take a weighted sum of the columns of a matrix
##  is by  matrix multiplication
#
## A big matrix that is the product of the lambdas and D's
#
	big.lD <- matrix(D, nrow = nl, ncol = nd, byrow = T) * matrix(lambda, 
		ncol = nd, nrow = nl)	#
#
#
	NUMER <- pure.ss + ((big.lD/(1 + big.lD))) %*% u^2
	MSE <- NUMER/N	#
	trA <- (1/(1 + big.lD)) %*% rep(1, np)	#
	DEN <- exp(log((1/(1 + big.lD))) %*% rep(1, np))
	lnL <- NUMER/DEN	#
## find global minimum of the GCV function
#
	mle.grid <- data.frame(lambda, trA, lnL, sqrt(MSE/(N - trA)))
	names(mle.grid) <- c("lambda", "trA", "lnL", "shat")
	mle.grid
}
