"pareto.plus"<-
function(x, xnames, xmax, sigline = F, prt.values = T, shade = F, digits = 3, 
	..., xlab = "", main = "", col = c(6, 1, 3), dens = c(10, 60), mar = c(
	5, 7, 4, 2) + 0.10000000000000001, plot.info = F, set.cex = 
	0.80000000000000004)
{
	if(!is.numeric(x))
		stop("x must be a numeric vector")
	old.par <- par(mar = mar)
	on.exit(par(old.par))
	ordef <- order(abs(x))
	if(missing(xnames))
		if(is.null(names(x)))
			xnames <- paste("x", 1:length(x), sep = "")
		else xnames <- names(x)
	if(missing(xmax))
		xmax <- max(abs(x))
	if(shade) {
		den <- round(x/abs(x), 0)
		den[den == -1] <- dens[1]
		den[den == 1] <- dens[2]
		y <- barplot(abs(x[ordef]), names = xnames[ordef], xlim = c(0, 
			xmax), horiz = T, density = den[ordef], ...)
	}
	else {
		cols <- round(x/abs(x), 0)
		cols[cols == 1] <- col[1]
		cols[cols == -1] <- col[2]
		y <- barplot(abs(x[ordef]), names = xnames[ordef], xlim = c(0, 
			xmax), horiz = T, col = cols[ordef], cex = set.cex, ...
			)
	}
	if(is.list(y))
		y <- y$center
	if(missing(xlab))
		xlab <- paste("Size of", deparse(substitute(x)))
	if(missing(main))
		main <- paste("Pareto Plot for", deparse(substitute(x)))
	title(main = main, xlab = xlab)
	if(any(sigline)) {
		nlines <- length(sigline)
		sig <- attr(sigline, "sig")
		line.types <- 1:nlines	# #  draw the lines
		for(i in 1:nlines)
			abline(v = sigline[i], lty = line.types[i], col = col[3
				])	# #  write the legend
#browser()
		usr <- par("usr")
		legx <- 0.55000000000000004 * (usr[2] - usr[1]) + usr[1]
		legy <- 0.25 * (usr[4] - usr[3]) + usr[3]
		if(nlines == 1) {
			meth <- if(!is.null(names(sigline))) paste("Method = ", 
				  names(sigline), "\n\n") else ""
			text(legx, legy, paste(meth, "Sig Level = ", format(
				signif(sig, 2)), sep = ""), adj = 0, cex = 
				set.cex)
		}
		else {
			text(legx, legy, paste("Significance Level = ", format(
				signif(sig, 2)), sep = ""), adj = 0, cex = 
				set.cex)
			leg.order <- order(sigline)
			legend(legx, legy - par("cxy")[2], names(sigline), lty
				 = line.types)
		}
	}
	if(any(plot.info)) {
		usr <- par("usr")
		legx <- 0.55000000000000004 * (usr[2] - usr[1]) + usr[1]
		legy1 <- 0.20000000000000001 * (usr[4] - usr[3]) + usr[3]
		legy2 <- 0.14999999999999999 * (usr[4] - usr[3]) + usr[3]
		legy3 <- 0.10000000000000001 * (usr[4] - usr[3]) + usr[3]
		text(legx, legy1, paste("N = ", plot.info[1]), adj = 0, cex = 
			set.cex)
		text(legx, legy2, paste("Df = ", round(plot.info[2], 1)), adj
			 = 0, cex = set.cex)
		text(legx, legy3, paste("Sigma = ", round(plot.info[3], 2)), 
			adj = 0, cex = set.cex)
	}
	if(prt.values)
		text(abs(x[ordef]), y, paste(" ", round(x[ordef], digits), sep
			 = ""), adj = 0)
	invisible()
}
