"plot.tps"<-
function(out, main = NA, digits = 4, graphics.reset = T, ..., which = c(T, T, T,
	T), plot.pareto = F)
{
## pdh 8/16/96 - added Q^2, pure error, changed some labels and
##   locations of text, add a gcvmin line if fit.pure.error=T
## DWN 9/26/96 changed arguments to fit in with new tps object
## pdh 10/29/96 - added drop=F to GCV matrix
## pdh 11/14/96 - x and y axes turned around on fit vs obs plot
## pdh 11/25/96 - uses r.squared instead of covariance if available
## swh 6/6/97 - add pareto plot option, add which option, print title on 2 lines
	old.par <- par("mfrow", "oma")
	if(graphics.reset) {
		on.exit(par(old.par))
		par(xpd = T)
	}
	if(sum(which) >= 3)
		set.panel(2, 2, T)
	else if(sum(which) == 2)
		set.panel(2, 1, T)
	else if(sum(which) == 1)
		set.panel(1, 1, T)
	temp <- summary(out)
	par1 <- par(pty = "s")
	lims <- range(out$fitted.values, out$y)	##plot 1
	if(which[1]) {
		plot(out$fitted.values, out$y, xlim = lims, ylim = lims, ylab
			 = "Observed Values", xlab = "Predicted Values", bty = 
			"n", ...)
		abline(0, 1)
		hold <- par("usr")
		if(!is.null(temp$r.square))
			r.square <- temp$r.square
		else r.square <- temp$covariance
		text(hold[1], hold[4], paste(" R^2 = ", format(round(100 * 
			r.square, 2)), "%", "\n", " Q^2 = ", format(round(100 * 
			temp$q2, 2)), "%", sep = ""), cex = 0.80000000000000004,
			adj = 0)
	}
	if(which[2]) {
		par(par1)
		maxres <- max(abs(out$residuals))
		plot(out$fitted.values, out$residuals, ylim = c( - maxres, 
			maxres), ylab = "Residuals", xlab = "Predicted values", 
			bty = "n", ...)
		yline(0)
		hold <- par("usr")
		if(!is.na(out$shat.pure.error))
			text(hold[1], hold[4], paste(" RMSE =", format(signif(
				out$shat, digits)), "\n", "Pure Error =", 
				format(signif(out$shat.pure.error, digits))), 
				cex = 0.80000000000000004, adj = 0)
		else text(hold[1], hold[4], paste(" RMSE =", format(signif(out$
				shat, digits))), cex = 0.80000000000000004, adj
				 = 0)
	}
	if(which[3]) {
		if(nrow(out$gcv.grid) > 1) {
## trim off + infinity due to pole in the denominator of GCV function
##with cost
			ind <- out$gcv.grid[, 3] < 1e+19
			out$gcv.grid <- out$gcv.grid[ind,  ]
			plot(out$gcv.grid[, 2], (out$gcv.grid[, 3]), xlab = 
				"Effective number of parameters", ylab = 
				"Average Prediction Error", bty = "n")
			xline(out$eff.df)
			hold <- par("usr")	##text(out$eff.df, hold[4], 
			text(hold[1], hold[4], paste(" Eff. df. =", format(
				round(out$eff.df, 1)), "\n Res. df. =", format(
				round(temp$num.observation - temp$enp, 1)), 
				"\n GCV min = ", round(out$GCV, 3)), cex = 
				0.80000000000000004, adj = 0)
			title("GCV", cex = 0.59999999999999998)
		}
	}
	if(which[4]) {
		if(!plot.pareto & (nrow(out$gcv.grid) > 1 & out$lambda != 0)) 
			{
			plot(out$gcv.grid[, 1], out$gcv.grid[, 3], xlab = 
				"Lambda", ylab = "GCV", log = "x", bty = "n")
			temp <- out$lambda.est[!is.na(out$lambda.est[, "lambda"
				]),  , drop = F]	##temp <- out$lambda.est
			hold <- par("usr")
			lam <- temp[, 1]
			names(lam) <- row.names(temp)	#print(lam)
			xline(lam)
			points(lam, temp[, "GCV"], mark = 1, cex = 
				1.1000000000000001)
			title(paste("GCV", "\n", " Lambda =", format(round(out$
				lambda, 5))), cex = 0.59999999999999998)
		}
		else if(plot.pareto & (out$m > 1)) {
			pareto.tps(out, main = "", set.cex = 
				0.80000000000000004, mar = c(4, 6, 2, 1))
			title("Pareto Plot of Null Space Coefficients", cex = 
				0.69999999999999996)
		}
	}
	if(is.na(main)) {
		mtext(deparse(out$call)[1], cex = 0.80000000000000004, outer = 
			T, line = -2)
		mtext(deparse(out$call)[2], cex = 0.80000000000000004, outer = 
			T, line = -3)
	}
	else mtext(main, cex = 0.80000000000000004, outer = T, line = -2)
	invisible()
}
