"rdist.earth"<-
function(loc1, loc2)
{
	if(missing(loc2))
		loc2 <- loc1
	R <- 6378/1.609
	lat <- loc1[, 2]
	lon <- loc1[, 1]
	coslat1 <- cos((lat * pi)/180)
	sinlat1 <- sin((lat * pi)/180)
	coslon1 <- cos((lon * pi)/180)
	sinlon1 <- sin((lon * pi)/180)
	lat <- loc2[, 2]
	lon <- loc2[, 1]
	coslat2 <- cos((lat * pi)/180)
	sinlat2 <- sin((lat * pi)/180)
	coslon2 <- cos((lon * pi)/180)
	sinlon2 <- sin((lon * pi)/180)
	PP1 <- cbind(coslat1 * coslon1, coslat1 * sinlon1, sinlat1)
	PP2 <- cbind(coslat2 * coslon2, coslat2 * sinlon2, sinlat2)
	pp <- (PP1 %*% t(PP2))
	R * acos(ifelse(pp > 1, 1, pp))
}
