\name{qsreg}
\alias{qsreg}
\title{
Quantile spline regression 
}
\description{
Uses a penalized likelihood approach to estimate the conditional 
quantile function for regression data. This method is only implemented 
for univariate data. For the pairs (X,Y) the 
conditional quantile, f(x), is  P( Y<f(x)| X=x) = alpha. This estimate 
is useful for deterring the envelope of a scatterplot or assessing 
departures from a constant variance with respect to the independent 
variable.   
}
\usage{


qsreg(x, y, lam=NA, maxit=50, maxit.cv=10, tol=0.0001, cost=2, offset=0,
sc=sqrt(var(y)) * 1e-07, alpha=0.5, wt=rep(1, length(x)), cost=1,
nstep.cv=100, hmin=NA, hmax=NA, trmin=2 * 1.05, trmax=0.95 *
length(unique(x))) 


}
\arguments{
\item{lam}{
Values of the smoothing parameter. If omitted is found by GCV based on the 
the quantile criterion
}
\item{maxit}{
Maximum number of iterations used to estimate each quantile spline.
}
\item{maxit.cv}{
Maximum number of iterations to find GCV minimum.
}
\item{tol}{
Tolerance for convergence when computing quantile spline.
}
\item{cost}{
Cost value used in the GCV criterion. Cost=1 is the usual GCV 
denominator.
}
\item{offset}{
Constant added to the effective degrees of freedom in the GCV function. 
}
\item{sc}{
Scale factor for quantile function. Default is a scale on the order of 
machine precision. Scales on the order of the residuals will result is a 
robust regression fit using the Huber weight function. 
}
\item{alpha}{
Quantile to be estimated. Default is find the median.
}
\item{wt}{
Weight vector default is constant values. Passing nonconstant weights is a
pretty strange thing to do. 
}
\item{nstep.cv}{
Number of points used in CV grid search


}
\item{hmin}{
Minimum value of log( lambda) used for GCV grid search.
}
\item{hmax}{
Maximum value of log( lambda) used for GCV grid search.
}
\value{


}
\item{trmin}{
Define the minimum and maximum values for the CV grid search in terms of
the effective number of parameters. (see hmin, hmax)




}}
\value{
Object of class qsreg with many arguments similar to sreg object. 
One difference is that cv.grid has five columns the last being 
the number of iterations for convergence at each value of lambda. 


}
\details{
This is an experimental function to find the smoothing parameter for a 
quantile spline using a more appropriate criterion than mean squared 
error prediction. 
The quantile spline is found by an iterative algorithm using weighted 
least squares cubic splines. At convergence the estimate will also be a 
weighted natural  cubic spline but the weights will depend on the
estimate.
Of course these weights are crafted so that the resulting spline is an 
estimate of the alpha quantile instead of the mean. 


 
}
\references{
Nychka,D. Oconnell, M. (1996)  "
}
\seealso{
sreg 
}
\examples{
qsreg(rat.diet$t,rat.diet$con)-> fit50 # fit a CV  quantile spline 
qsreg(rat.diet$t,rat.diet$con)-> fit50 # fit a CV  quantile spline
# (default is .5 so this is an estimate of the conditional median)
# control group of rats.
# The global GCV function is weird but local minima with largest lambda
#value is used.
plot( fit50)
predict( fit50) # predicted values at data points
xg<- seq(0,110,,50)
plot( fit$x, fit$y) # the data
qsreg(rat.diet$t,rat.diet$con, alpha=.1)-> fit10
qsreg(rat.diet$t,rat.diet$con, alpha=.9)-> fit90


# spline fits at 50 equally spaced points
sm<- cbind(
predict( fit10, xg),  
predict( fit50, xg),  
predict( fit90, xg))  
# and now zee data \dots
plot( fit50$x, fit50$y)
# and now zee quantile splines at 10\% 50\% and 90\%. 
#
matlines( xg, sm) # the spline


 
}
\keyword{quantile}
% Converted by Sd2Rd version 0.3-2.


