"cover.design"<-
function(R, nd, nruns = 1, nn = T, num.nn = 100, max.loop = 30, fixed = NULL, 
	scale.type = "unscaled", R.center, R.scale, P = -32, Q = 32, start = 
	NULL, DIST = NULL, return.grid = T, return.transform = F)
{
## this version calls the fortran from unix
##
##BD group  prefers a default for scale.type that is better for designed 
## experiments: 
## scale.type = "range", 
##
	if((nrow(R) > 20000) | (nd > 400) | (ncol(R) > 20)) stop(
			"Error: Candidate Pts < 40001, Design < 401, Dimension < 21"
			)
	if(( - P) %% 2 != 0)
		stop("Error: P value must have even number")
	if(!is.null(start) && is.matrix(start)) {
		if(any(dup.matrix(start)))
			stop("Error: start must not have duplicate rows")
		start <- rowmatch(start, R)
		if(any(is.na(start)))
			stop("Error: Starting design must be a subset of R")
	}
	R.orig <- R
	R <- as.matrix(R)
	if(any(dup.matrix(R)))
		stop("Error: R must not have duplicate rows")
	if(num.nn >= nrow(R))
		nn <- F
	if(is.null(DIST))
		DIST <- function(x, y)
		{
			rdist(x, y)
		}
	id <- 1:nrow(R)
	if(!is.null(start))
		nd <- length(start)
	if(is.null(fixed))
		n <- nd
	else {
		if(any(dup.matrix(fixed)))
			stop("Error: fixed must not have duplicate rows")
		if(is.matrix(fixed)) {
			fixed <- rowmatch(fixed, R)
			if(any(is.na(fixed)))
				stop(
				  "Error: fixed points must be included in R")
		}
		n <- nd + length(fixed)
	}
	R <- transformx(R, scale.type, R.center, R.scale)	
	### write out files to communicate to Fortran
	write(R, file = "R.tmp", ncolumns = ncol(R))
	write(nd, file = "c.tmp", append = F)
	write(nrow(R), file = "c.tmp", append = T)
	write(ncol(R), file = "c.tmp", append = T)
	write(P, file = "c.tmp", append = T)
	write(Q, file = "c.tmp", append = T)
	write(nn, file = "c.tmp", append = T)
	write(num.nn, file = "c.tmp", append = T)
	write(n, file = "c.tmp", append = T)
	write(nrow(R) - n, file = "c.tmp", append = T)
	write(max.loop, file = "c.tmp", append = T)
	transform <- attributes(R)
	saved.crit <- rep(NA, nruns)
	minimax <- rep(NA, nruns)
	saved.designs <- matrix(NA, nrow = nruns, ncol = n)
	saved.hist <- list()
	for(RUNS in 1:nruns) {
		if(is.null(start)) {
			if(!is.null(fixed)) {
				Dset <- sample((1:nrow(R))[ - fixed], nd)
				Dset <- c(Dset, fixed)
			}
			else Dset <- sample(1:nrow(R), nd)
		}
		else {
			if(length(start) > nd)
				stop(
				  "Error: the start matrix must have nd rows")
			Dset <- start
			if(!is.null(fixed))
				Dset <- c(Dset, fixed)
		}
		design.original <- R[Dset,  ]
		Dset.orginal <- Dset
		write(Dset, file = "Dset.tmp")
		unix(paste(FUNFITS.BIN, "cover", sep = ""))
		outp <- scan("output")
		Dset <- outp[1:n]
		nhist <- outp[n + 1]
		nloop <- outp[n + 2]
		hist <- matrix(outp[(n + 3):length(outp)], nrow = nhist, ncol
			 = 3, byrow = T)
		crit.i <- hist[nhist, 3]
		crit.original <- hist[1, 3]
		saved.crit[RUNS] <- crit.i
		saved.designs[RUNS,  ] <- Dset
		minimax[RUNS] <- minimax.crit(saved.designs[RUNS,  ], F, R.orig
			)
		saved.hist[[RUNS]] <- hist
	}
	ret <- (1:nruns)[saved.crit == min(saved.crit)]
	if(length(ret) > 1) {
		print("Greater than 1 optimal design; keeping first one......")
		ret <- ret[1]
	}
	unix("rm R.tmp")
	unix("rm Dset.tmp")
	unix("rm c.tmp")
	unix("rm output")
	crit.i <- saved.crit[ret]
	hist <- saved.hist[[ret]]
	nh <- nrow(hist)
	hist <- cbind(c(0:(nrow(hist) - 1)), hist)
	dimnames(hist) <- list(NULL, c("step", "swap.out", "swap.in", 
		"new.crit"))	
	### return a data frame with attributes rather than a list
	out.des <- R[saved.designs[ret,  ],  ]
	out.des <- unscale(out.des, transform$x.center, transform$x.scale)
	out <- data.frame(out.des)
	attr(out, "call") <- match.call()
	class(out) <- c("spatial.design", "data.frame", "matrix")
	attr(out, "best.id") <- c(saved.designs[ret,  ])
	attr(out, "fixed") <- fixed
	attr(out, "opt.crit") <- crit.i
	attr(out, "start.design") <- design.original
	attr(out, "start.crit") <- crit.original
	attr(out, "history") <- hist
	attr(out, "other.designs") <- saved.designs
	attr(out, "other.crit") <- saved.crit
	attr(out, "DIST") <- DIST
	attr(out, "nn") <- nn
	attr(out, "num.nn") <- num.nn
	if(return.grid)
		attr(out, "grid") <- R.orig
	if(return.transform)
		attr(out, "transform") <- transform
	attr(out, "P") <- P
	attr(out, "Q") <- Q
	attr(out, "nhist") <- nhist - 1
	attr(out, "nloop") <- (nloop - 1)/n
	attr(out, "minimax.crit") <- minimax
	attr(out, "max.loop") <- max.loop
	out
}
