"eubanks.s.fun"<-
function(xmat, y, Smat.out = NULL, n.p = NULL, print.trace = F)
{
	xmat <- as.matrix(xmat)
	if(is.null(n.p))
		n.p <- dim(xmat)[[2]] + 1
	if(is.null(Smat.out))
		Smat <- Smat.function2(xmat, n.points = n.p)$Smat
	n.obs <- dim(xmat)[[1]]
	IminusS <- diag(rep(1, n.obs)) - Smat
	pseudo.res <- y - Smat %*% y
	sum.p.r.sq <- colsum(as.matrix(pseudo.res^2))
	shat <- sqrt(sum.p.r.sq/tr(t(IminusS) %*% IminusS))
	if(print.trace) {
		browser()
		print(tr(t(IminusS) %*% IminusS))
	}
	list(pseudo.res = round(pseudo.res, 4), shat = shat)
}
