"fast.1way"<-
function(lev, y, w = rep(1, length(y)))
{
#swh 2/25/98
	N <- length(y)	#convert levels to consecutive integers
	lev <- match(lev, unique(lev))
	id <- order(lev)	#
# find the breaks between groups in the sorted y
#
	brk <- c(diff(lev[id]) != 0, T)
	w.means <- diff(c(0, cumsum(w[id])[brk]))
	means <- diff(c(0, cumsum(y[id] * w[id])[brk]))/w.means
	n <- diff(c(0, (1:N)[brk]))
	SSE <- sum(w * (y - means[lev])^2)
	MSE <- SSE/(length(y) - length(n))
	list(means = means, n = n, SSE = SSE, MSE = MSE, fitted.values = means[
		lev])
}
