"image.plot"<-
function(..., nlevel = 32, legend.shrink = 0.90000000000000002, legend.width = 
	0.02, graphics.reset = T, horizontal = F, offset = 0.040000000000000001,
	bigplot = NULL, smallplot = NULL, legend.only = F)
{
	old.par <- par()
	info <- image.plot.info(...)
	if(is.null(smallplot))
		stick <- T
	else stick <- F
	if(is.null(smallplot)) {
		smallplot <- old.par$plt
		if(horizontal) {
			smallplot[3] <- offset
			smallplot[4] <- smallplot[3] + legend.width
			pr <- (smallplot[2] - smallplot[1]) * ((1 - 
				legend.shrink)/2)
			smallplot[1] <- smallplot[1] + pr
			smallplot[2] <- smallplot[2] - pr
		}
		else {
			smallplot[2] <- 1 - offset
			smallplot[1] <- smallplot[2] - legend.width
			pr <- (smallplot[4] - smallplot[3]) * ((1 - 
				legend.shrink)/2)
			smallplot[4] <- smallplot[4] - pr
			smallplot[3] <- smallplot[3] + pr
		}
	}
	if(is.null(bigplot)) {
		bigplot <- old.par$plt
		if(!horizontal) {
			bigplot[2] <- min(bigplot[2], smallplot[1] - offset)
		}
		else {
			bottom.lines <- old.par$mar[1]
			if(bottom.lines > 0) {
				off2 <- (3 * bigplot[1])/bottom.lines
			}
			else {
				off2 <- 0
			}
			bigplot[3] <- max(bigplot[3] - off2, smallplot[4] + 
				offset)
		}
	}
	if(stick) {
		if(!horizontal) {
			dp <- smallplot[2] - smallplot[1]
			smallplot[1] <- min(bigplot[2] + offset, smallplot[1])
			smallplot[2] <- smallplot[1] + dp
		}
	}
	if(!legend.only) {
		par(plt = bigplot)
		image(...)
		big.par <- par()
	}
	if((smallplot[2] < smallplot[1]) | (smallplot[4] < smallplot[3])) {
		par(old.par)
		stop("plot region too small to add legend\n")
	}
	temp <- list(...)
	iy <- seq(info$zlim[1], info$zlim[2],  , nlevel)
	iz <- matrix(iy, nrow = 1, ncol = length(iy))
	ix <- 1
	if(!horizontal) {
		par(new = T, pty = "c", plt = smallplot, mar = c(0, 0, 0, 
			3.1000000000000001), err = -1)
		image(ix, iy, iz, xaxt = "n", yaxt = "n")
		axis(4, mgp = c(3, 0, 0))
	}
	else {
		par(new = T, pty = "c", plt = smallplot, mar = c(
			3.1000000000000001, 0, 0, 0), err = -1)
		image(iy, ix, t(iz), yaxt = "n", mgp = c(3, 0, 0))
	}
	if(graphics.reset) {
		par(plt = old.par$plt, mar = old.par$mar, new = F, pty = 
			old.par$pty)
		invisible()
	}
	else {
		par(big.par)
		invisible()
	}
}
