"krig"<-
function(x, Y, cov.function = exp.cov, lambda = NA, cost = 1, knots, weights = 
	rep(1, length(Y)), m = 2, return.matrices = T, nstep.cv = 10, 
	scale.type = "user", x.center = rep(0, ncol(x)), x.scale = rep(1, ncol(
	x)), rho = NA, sigma2 = NA, method = "GCV", decomp = "DR", verbose = F, 
	cond.number = 10^8, mean.obj = NULL, sd.obj = NULL, yname = NULL, ...)
{
# S function to find minimizer of 
#  || Y- Xb||^2 + lambda b^T H b where H is a 
# covariance matrix found from cov.function
# Solution for b is  b= (X^T*X + lambda*H)^(-1) X^T*Y
#  H is the covariance matrix 
#
	out <- list()
	class(out) <- c("krig", "funfits")
	out$call <- match.call()	#
	N <- length(Y)	#
# 
	if(is.null(yname))
		out$yname <- deparse(substitute(Y))
	else out$yname <- yname
	out$N <- N
	out$decomp <- decomp	#
###
### add passed theta arguments to the covariance function
	temp <- list(...)
	ntemp <- names(temp)
	if(length(temp) > 0) {
		for(k in 1:length(ntemp)) {
			cov.function[ntemp[k]] <- temp[ntemp[k]]
		}
		cov.function <- as.function(cov.function)
	}
	out$cov.function <- cov.function	#
	x <- as.matrix(x)	# make sure that the columns of x have names
#
# add row and col names if they are missing.
# 
	if(length(dimnames(x)) != 2) {
		dimnames(x) <- list(format(1:nrow(x)), paste("X", format(1:ncol(
			x)), sep = ""))
	}
	if(length(dimnames(x)[[1]]) == 0) {
		dimnames(x)[[1]] <- format(1:nrow(x))
	}
	if(length(dimnames(x)[[2]]) == 0) {
		dimnames(x)[[2]] <- paste("X", format(1:ncol(x)), sep = "")
	}
#
#
#
	Y <- c(Y)	# make sure Y is a vector!
	out$y <- Y
	out$x <- x	#
# transform Y by mean and sd if needed
#add logical flag in output object to indciate this has been done
#
	if(!is.null(sd.obj) & !is.null(mean.obj)) {
		correlation.model <- T
	}
	else correlation.model <- F
	out$correlation.model <- correlation.model
	if(correlation.model) {
		Yraw <- Y
		out$mean.obj <- mean.obj
		out$sd.obj <- sd.obj
		Y <- (Y - predict(mean.obj, x))/predict(sd.obj, x)
		if(verbose)
			print(Y)
	}
#
#
#
	out$weights <- weights	#
## makes sense
	rep.info <- cat.matrix(x)	## integer tags to indicate replications
	if(verbose)
		print(rep.info)
	if(max(rep.info) == N) {
		shat.rep <- NA
		shat.pure.error <- NA
		out$pure.ss <- 0
		YM <- Y
		weightsM <- weights
		xM <- as.matrix(x[!dup(rep.info),  ])
	}
	else {
##
## do a simple 1-way ANOVA to get the replication error
##
		rep.info.aov <- fast.1way(rep.info, Y, weights)
		shat.pure.error <- sqrt(rep.info.aov$MSE)
		shat.rep <- shat.pure.error
		YM <- rep.info.aov$means
		weightsM <- rep.info.aov$w.means
		xM <- as.matrix(x[!dup(rep.info),  ])
		out$pure.ss <- rep.info.aov$SSE
		if(verbose)
			print(rep.info.aov)
	}
	out$yM <- YM
	out$xM <- xM
	out$weightsM <- weightsM
	out$shat.rep <- shat.rep
	out$shat.pure.error <- shat.pure.error
	if(missing(knots))
		knots <- xM
	knots <- as.matrix(knots)
	out$knots <- knots	##
#
## scale x and knots 
	xM <- transformx(xM, scale.type, x.center, x.scale)
	transform <- attributes(xM)
	if(verbose) {
		cat("transform", fill = T)
		print(transform)
	}
	knots <- scale(knots, center = transform$x.center, scale = transform$
		x.scale)
	if(verbose) {
		cat("knots in transformed scale", fill = T)
		print(knots)
	}
	out$transform <- transform	##
##
##  use value of lambda implied by rho and simga2 if these are passed
##
	if(!is.na(lambda))
		method <- "user"
	if(!is.na(rho) & !is.na(sigma2)) {
		lambda <- sigma2/rho
		method <- "user"
	}
	just.solve <- (lambda[1] == 0)
	if(is.na(just.solve)) just.solve <- F	#
#
	if(verbose) cat("lambda", lambda, fill = T)	#
#
	d <- ncol(xM)	# make up the T and K matrices
# find the QR decopmposition of T matrix  that spans null space with
# respect to the knots 
# the big X matrix
#
	if(decomp == "DR") {
		qr.T <- qr(make.tmatrix(knots, m))	#
		if(verbose) {
			print(qr.T)
			print((cov.function(knots, knots)))
		}
		tempM <- qr.yq2(qr.T, cov.function(knots, knots))
		tempM <- qr.q2ty(qr.T, tempM)
		if(verbose) {
			print(dim(tempM))
		}
	}
	if(decomp == "WBW") {
#
#   construct the covariance matrix 
#functions and Qr decomposition of T
#
		qr.T <- qr(sqrt(weightsM) * make.tmatrix(knots, m))	#
#
#
		tempM <- sqrt(weightsM) * t(sqrt(weightsM) * t(cov.function(
			knots, knots)))
		tempM <- qr.yq2(qr.T, tempM)
		tempM <- qr.q2ty(qr.T, tempM)
	}
	np <- nrow(knots)	# the number of parameters
	nt <- (qr.T$rank)	# number of para. in NULL space
	out$np <- np
	out$nt <- nt
	if(verbose)
		cat("np, nt", np, nt, fill = T)
	if(verbose)
		print(knots)	# if lambda = 0 then just solve the system 
	if(just.solve) {
		beta <- qr.coef(qr(cbind(make.tmatrix(xM, m), qr.yq2(qr.T, 
			cov.function(xM, knots)))), YM)
	}
	else {
#
#   do all the heavy decompositions if lambda is not = 0
#   or if it is omitted
#
#
####
####
#### Block for Full Demmler Reinsch decomposition
#####
		if(decomp == "DR") {
			if(verbose) cat("Type of decomposition", decomp, fill
				   = T)	#
## make up penalty matrix
#
			H <- matrix(0, ncol = np, nrow = np)
			H[(nt + 1):np, (nt + 1):np] <- tempM	#
#
# svd of big X matrix in preparation for finding inverse square root
#
			X <- cbind(make.tmatrix(xM, m), qr.yq2(qr.T, 
				cov.function(xM, knots)))
			if(verbose) {
				print(weightsM)
				print(X)
			}
			temp <- svd(sqrt(weightsM) * X)[c("v", "d")]
			cond.matrix <- max(temp$d)/min(temp$d)
			if(cond.matrix > cond.number) stop(
				  "Covariance matrix is close\nto singular")	#
# inverse symetric square root of X^T W  
#
			B <- temp$v %*% diag(1/(temp$d)) %*% t(temp$v)	#
#   eigenvalue eigenvector decomposition of BHB
#
			temp <- svd(B %*% H %*% B)
			U <- temp$u
			D <- temp$d	#
			if(verbose) {
				cat("singular values:", fill = T)
				print(D)
			}
#   We know that H has atleast nt zero singular values ( see how H is
#   filled)
#   So make these identically zero.
#   the singular values are returned from largest to smallest.
#
			D[(1:nt) + (np - nt)] <- 0
			G <- B %*% U	#
#   with these these decompositions it now follows that 
#     b= B*U( I + lambda*D)^(-1) U^T * B * X^T*Y
#      = G*( I + lambda*D)^(-1) G^T* X^T*Y
#	
# Now tranform  Y based on this last equation
#
			u <- t(G) %*% t(X) %*% (weightsM * YM)	#
#
#   So now we have   
#
#    b= G*( I + lambda*D)^(-1)*u 
#   Note how in this form we can rapidly solve for b for any lambda
#
# save matrix decopositions in out list
#
# find the pure error sums of sqaures. 
#
			out$pure.ss <- sum(weightsM * (YM - X %*% G %*% u)^2) + 
				out$pure.ss
			if(verbose) {
				cat("pure.ss", fill = T)
				print(out$pure.ss)
			}
			out$matrices <- list(B = B, U = U, u = u, D = D, G = G, 
				qr.T = qr.T)
		}
#####
##### end DR decomposition block 
#####
####
#### begin WBW decomposition block
####
		if(decomp == "WBW") {
#### decomposition of Q2TKQ2
			temp <- svd(tempM)[c("d", "v")]
			D <- c(rep(0, nt), 1/temp$d)
			if(verbose) {
				cat("singular values:", fill = T)
				print(D)
			}
			G <- matrix(0, ncol = np, nrow = np)	#
			G[(nt + 1):np, (nt + 1):np] <- temp$v
			G <- G * matrix(D, ncol = np, nrow = np, byrow = T)
			u <- c(rep(0, nt), t(temp$v) %*% qr.q2ty(qr.T, sqrt(
				weightsM) * YM))
			if(verbose) cat("u", u, fill = T)	#
# pure error in this case is found for the 1way ANOVA 
#
# test for replicates
#
			if(verbose) {
				cat("pure.ss", fill = T)
				print(out$pure.ss)
			}
			out$matrices <- list(u = u, D = D, G = G, qr.T = qr.T, 
				decomp = decomp, V = temp$v)
		}
#####
##### end WBW block
#####
		gcv.out <- gcv.krig(out, nstep.cv = nstep.cv, verbose = verbose
			)
		gcv.grid <- gcv.out$gcv.grid
		out$gcv.grid <- gcv.grid
		if(verbose) {
			print(out$gcv.grid)
		}
	}
	if(method == "user") {
		lambda.best <- lambda
	}
	else {
		lambda.best <- gcv.out$lambda.best
	}
	beta <- G %*% ((1/(1 + lambda.best * D)) * u)	
	# add in null space parameters if this WBW decomp
#
#
	out$cost <- cost
	out$m <- m
	if(!just.solve) {
		out$eff.df <- sum(1/(1 + lambda.best * D))
		out$trace <- out$eff.df
		if(verbose) {
			cat("trace of A", fill = T)
			print(out$trace)
		}
	}
	else {
		out$eff.df <- out$np
	}
	if(just.solve)
		out$lambda <- lambda
	else out$lambda <- lambda.best
	out$beta <- beta	##
#
# tranform the beta into the parameter associated with the covariance
# function
# basis set. 
#  into the c parameter vector. 
#
#   	temp <- c(rep(0, nt), beta[(nt + 1):np])
#	if(verbose)
#		print(temp)
	out$c <- c(qr.qy(qr.T, c(rep(0, nt), beta[(nt + 1):np])))
	if(decomp == "WBW") {
		out$c <- out$c * sqrt(weightsM)
	}
	if(verbose) print(out$c)	#
#
	if(decomp == "DR") {
		out$d <- beta[1:nt]
	}
#
#
# some special manipulations when WBW decomposition is used. 
#
	if(decomp == "WBW") {
		temp <- YM - lambda.best * out$c - cov.function(knots, knots) %*% 
			out$c	# multiply through by weights
		temp <- sqrt(weightsM) * temp
		out$d <- qr.coef(qr.T, temp)
	}
#
# find predicted values and residuals. 
#
	if(verbose) {
		cat(names(out), fill = T)
	}
	out$fitted.values <- predict.krig(out, x, eval.correlation.model = F)	#
#  need eval.correlation.model = F in order to get predicted's in the
# standardized scale of Y
# 
	out$residuals <- Y - out$fitted.values	#
# funny conversions are in case nt is equal to 1 and X is just a vector
#
	out$fitted.values.null <- as.matrix(make.tmatrix(x, m)) %*% out$d	#
#
#
	out$just.solve <- just.solve	#
	out$shat.GCV <- sqrt(sum(out$weights * out$residuals^2)/(length(Y) - 
		out$trace))	#
# fill in the linear parameters of the covariance function in 
# the output object
#
# the next formula is pretty strange. It follows from solving the
# system of equations for the basis coefficients. 
#       
	out$rhohat <- sum(out$c * out$yM)/(N - nt)	#
	if(is.na(rho)) {
		out$rho <- out$rhohat
	}
	else out$rho <- rho
	if(is.na(sigma2))
		sigma2 <- out$rho * out$lambda
	out$sigma2 <- sigma2	#
	out$shat.MLE <- sqrt(out$rhohat * out$lambda)	#
	out$best.model <- c(out$lambda, out$sigma2, out$rho)	##
## wipe out big matrices if they are not to be returned
##
##
	if(!return.matrices) {
		out$xM <- NUll
		out$YM <- NULL
		out$x <- NULL
		out$y <- NULL
		out$matrices <- NULL
		out$weights <- NULL
	}
##
##
	out
}
