"lon.lat.to.xy"<-
function(lon.lat)
{
	x <- lon.lat[, 1]
	y <- lon.lat[, 2]
	mx <- mean(x)
	my <- mean(y)
	temp <- cbind(rep(mx, 2), range(y))
	sy <- rdist.earth(temp)[2, 1]
	temp <- cbind(range(x), rep(my, 2))
	sx <- rdist.earth(temp)[2, 1]
	temp <- list(x = sx/(max(x) - min(x)), y = sy/(max(y) - min(y)))
	cbind((x - mx) * temp$x, (y - my) * temp$y)
}
