"plot.ushell"<-
function(n.factors = 2, factor.names.arg = std.factor.names(n.factors), 
	n.shells = 1, logx = F, digits = 4)
{
## graph a two dimensional uniform shell design
## assume that it is generated on -1 to 1
	des <- ushell.design(n.factors, factor.names.arg, n.shells = n.shells, 
		logx)
	if(n.factors == 2) {
		old.par <- par(pty = "s")
		on.exit(par(old.par))
		x <- des[, 1]
		y <- des[, 2]
		n <- nrow(des)
		c.i <- (1:n)[x == 0 & y == 0]
		d.vec <- sqrt(x^2 + y^2)
		d.vec[d.vec <= 10^( - digits)] <- 0
		d.vec <- round(d.vec, digits)
		mv <- max(d.vec) + 0.10000000000000001
		lims <- c( - mv, mv)
		plot(x, y, xlim = lims, ylim = lims, type = "n")
		points(0, 0, mark = 1, col = 1)
		r.vals <- sort(unique(d.vec))[-1]
		n.r <- length(r.vals)
		for(i in 1:n.r) {
			points(x[d.vec == r.vals[i]], y[d.vec == r.vals[i]], 
				mark = i + 1, col = i + 1)
			symbols(0, 0, circles = r.vals[i], inches = F, add = T, 
				col = i + 1)
		}
		mtext(side = 3, line = -3, outer = T, cex = 1.5, paste(
			"Rhombic Lattice (Uniform Shell) Design", 
			"\nNumber of Shells =", n.shells, "\nn =", n, 
			"\nRadii = ", paste(round(sort(r.vals), 3), collapse = 
			", ")))
	}
	invisible()
}
