"predict.se.krig"<-
function(out, x, cov.function, rho, sigma2, weights = NULL, cov = F, stationary
	 = T, fixed.mean = T)
{
# NOTE: to follow along 
# if lambda is an estimate of the random field at a point
# and lambda_hat is an estimate based on linear combination of the data
#
# MSE( lambda - lambda_hat) = VAR( lambda) - 2* COV( lambda, lambda_hat)
#      + VAR( lambda_hat)
#
# Perhaps the most confusing aspect of this code is that the MSE
# are found simultanouesly for all the points in x.
# This is to avoid an explicit for loop 
#
#
# 
	if(missing(x)) x <- out$x
	x <- as.matrix(x)	
	########## if covariance function and parameters are missing
########## extract them from the krig object
	if(missing(cov.function)) {
		fun <- out$cov.function
	}
	else {
		fun <- cov.function
	}
	if(missing(sigma2)) {
		sigma2 <- out$sigma2
	}
#
# OK now fix the right value for sigma
#
	if(missing(rho)) {
		rho <- out$rho
	}
#
	if(!is.null(fun$marginal)) stationary <- F	#
	lambda <- sigma2/rho
	if(lambda != 0) {
		if((lambda - out$lambda)/lambda > 1e-08) {
			warning("lambda value used is different from the one in the krig object"
				)
			cat(lambda, out$lambda, fill = T)
		}
	}
	nx <- nrow(out$xM)	#
#       figure out if this is a correlation model and make adustments
	temp.sd <- 1
	var.mean <- 0
	if(out$correlation.model) {
		temp.sd <- predict(out$sd.obj, x)
		if(!fixed.mean) {
			var.mean <- predict.se(out$mean.obj, x)^2
		}
	}
#
# here is where the real fun begins
#
# wght.vec are the linear combinations of the data ( yM the averages
# if there are replicates) that give the 
# correpsonding estimates of the function at the points x
	wght.vec <- t(make.Amatrix(out, x, lambda))	#
# modify weight.vec to give the weighted estimated 
#	
# Cy is the observed covariance matrix of the data vector
	Cy <- rho * fun(out$xM, out$xM) + sigma2 * diag(1/out$weightsM)	#
	if(cov) {
		temp <- rho * fun(x, out$xM) %*% wght.vec
		temp <- (rho * fun(x, x) - temp - t(temp) + t(wght.vec) %*% Cy %*% 
			wght.vec)
		return(temp)
	}
#
# this is the second term in the MSE
	temp1 <- rho * c(t(wght.vec * fun(out$xM, x)) %*% rep(1, nx))	#
# this is the third term in the MSE 
	temp2 <- c(t(wght.vec * (Cy %*% wght.vec)) %*% rep(1, nx))	#
# VAR of lambda, the first term is handled differently depending on 
# if this is the MSE at a point or a weighted combination
#
	if(stationary) {
		x0 <- matrix(0, ncol = ncol(x), nrow = 1)
		temp <- (rho * fun(x0, x0) - 2 * temp1 + temp2)
		return(sqrt(temp * temp.sd + var.mean))
	}
#
#
# if covariance is not stationary then loop through each point to get
# the variance of field at that point. 
#
#
	if(is.null(fun$marginal)) {
		temp <- rep(0, nrow(x))
		for(k in 1:nrow(x)) {
			x0 <- matrix(x[k,  ], nrow = 1)
			temp[k] <- rho * fun(x0, x0) - 2 * temp1[k] + temp2[k]
		}
	}
	else {
#
## marginal variances available by single call
#
		temp <- rho * fun(x, marginal = T) - 2 * temp1 + temp2
	}
	return(sqrt(temp.sd * temp + var.mean))
}
