"surface.3way"<-
function(fit, by.varname, y.name, zlim, logy = F)
{
## swh 1/8/97
## makes surface plots by other two variables at each level of the variable
## specified with by.varname
## Notes: 
##   1.this function ONLY works when there are 3 variables in the x matrix
##   2. y.name is only used in the title
##   3. by.varname must be in quotes
	k.levs <- sort(unique(fit$x[, by.varname]))
	n.k <- length(k.levs)
	if(n.k > 12)
		return("More than 12 levels of by variable")
	old.par <- par(mfrow = c(ceiling(n.k/2), 2), oma = c(0, 0, 4, 0))
	on.exit(par(old.par))
	if(missing(zlim)) {
		y <- fit$y
		if(logy)
			zlim <- range(exp(y)) * c(0.94999999999999996, 1.05)
		else zlim <- range(y) * c(0.94999999999999996, 1.05)
	}
	if(missing(y.name)) y.name <- fit$yname	##setting up grid list
	xnames <- dimnames(fit$x)[[2]]
	byvar <- match(xnames, by.varname)
	gl <- as.list(apply(fit$x, 2, function(x)
	NA))
	names(gl) <- xnames
	gl.byvar <- c(1, 2, 3)[!is.na(byvar)]
	gl.xy <- c(1, 2, 3)[is.na(byvar)]
	gl[[gl.xy[1]]] <- "x"
	gl[[gl.xy[2]]] <- "y"
	for(i in 1:n.k) {
		gl[[gl.byvar]] <- k.levs[i]	
	#sets by var to level in the grid list
		ss1 <- predict.surface(fit, grid.list = gl)
		if(logy)
			ss1$z <- exp(ss1$z)
		persp(ss1, zlim = zlim, xlab = xnames[gl.xy[1]], ylab = xnames[
			gl.xy[2]])
		title(paste(by.varname, "=", k.levs[i]), cex = 
			0.80000000000000004)
	}
	mtext(side = 3, outer = T, line = 1, cex = 1.2, text = paste(
		"Response Surface for", y.name))
	invisible()
}
